@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of an existing Shared Private Link Resource managed by the Azure Cognitive Search service.
 * @property groupId The group id from the provider of resource the shared private link resource is for.
 * @property privateLinkResourceId The resource id of the resource the shared private link resource is for.
 * @property provisioningState The provisioning state of the shared private link resource. Can be Updating, Deleting, Failed, Succeeded or Incomplete.
 * @property requestMessage The request message for requesting approval of the shared private link resource.
 * @property resourceRegion Optional. Can be used to specify the Azure Resource Manager location of the resource to which a shared private link is to be created. This is only required for those resources whose DNS configuration are regional (such as Azure Kubernetes Service).
 * @property status Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
 */
public data class SharedPrivateLinkResourcePropertiesResponse(
    public val groupId: String? = null,
    public val privateLinkResourceId: String? = null,
    public val provisioningState: String? = null,
    public val requestMessage: String? = null,
    public val resourceRegion: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.SharedPrivateLinkResourcePropertiesResponse): SharedPrivateLinkResourcePropertiesResponse = SharedPrivateLinkResourcePropertiesResponse(
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            privateLinkResourceId = javaType.privateLinkResourceId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
            resourceRegion = javaType.resourceRegion().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
