@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [APICollection].
 */
@PulumiTagMarker
public class APICollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: APICollectionArgs = APICollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend APICollectionArgsBuilder.() -> Unit) {
        val builder = APICollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): APICollection {
        val builtJavaResource = com.pulumi.azurenative.security.APICollection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return APICollection(builtJavaResource)
    }
}

/**
 * An API collection as represented by Defender for APIs.
 * Azure REST API version: 2022-11-20-preview.
 * ## Example Usage
 * ### Onboard an Azure API Management API to Defender for APIs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiCollection = new AzureNative.Security.APICollection("apiCollection", new()
 *     {
 *         ApiCollectionId = "echo-api",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAPICollection(ctx, "apiCollection", &security.APICollectionArgs{
 * 			ApiCollectionId:   pulumi.String("echo-api"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.APICollection;
 * import com.pulumi.azurenative.security.APICollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiCollection = new APICollection("apiCollection", APICollectionArgs.builder()
 *             .apiCollectionId("echo-api")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:APICollection echo-api /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/providers/Microsoft.Security/apiCollections/{apiCollectionId}
 * ```
 */
public class APICollection internal constructor(
    override val javaResource: com.pulumi.azurenative.security.APICollection,
) : KotlinCustomResource(javaResource, APICollectionMapper) {
    /**
     * Additional data regarding the API collection.
     */
    public val additionalData: Output<Map<String, String>>?
        get() = javaResource.additionalData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The display name of the Azure API Management API.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object APICollectionMapper : ResourceMapper<APICollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.APICollection::class == javaResource::class

    override fun map(javaResource: Resource): APICollection = APICollection(
        javaResource as
            com.pulumi.azurenative.security.APICollection,
    )
}

/**
 * @see [APICollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [APICollection].
 */
public suspend fun apiCollection(
    name: String,
    block: suspend APICollectionResourceBuilder.() -> Unit,
): APICollection {
    val builder = APICollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [APICollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiCollection(name: String): APICollection {
    val builder = APICollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
