@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.AdaptiveApplicationControlIssueSummaryResponse
import com.pulumi.azurenative.security.kotlin.outputs.PathRecommendationResponse
import com.pulumi.azurenative.security.kotlin.outputs.ProtectionModeResponse
import com.pulumi.azurenative.security.kotlin.outputs.VmRecommendationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.security.kotlin.outputs.AdaptiveApplicationControlIssueSummaryResponse.Companion.toKotlin as adaptiveApplicationControlIssueSummaryResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.PathRecommendationResponse.Companion.toKotlin as pathRecommendationResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.ProtectionModeResponse.Companion.toKotlin as protectionModeResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.VmRecommendationResponse.Companion.toKotlin as vmRecommendationResponseToKotlin

/**
 * Builder for [AdaptiveApplicationControl].
 */
@PulumiTagMarker
public class AdaptiveApplicationControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AdaptiveApplicationControlArgs = AdaptiveApplicationControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AdaptiveApplicationControlArgsBuilder.() -> Unit) {
        val builder = AdaptiveApplicationControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AdaptiveApplicationControl {
        val builtJavaResource =
            com.pulumi.azurenative.security.AdaptiveApplicationControl(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AdaptiveApplicationControl(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2020-01-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2015-06-01-preview.
 * ## Example Usage
 * ### Update an application control machine group by adding a new application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adaptiveApplicationControl = new AzureNative.Security.AdaptiveApplicationControl("adaptiveApplicationControl", new()
 *     {
 *         AscLocation = "centralus",
 *         EnforcementMode = "Audit",
 *         GroupName = "ERELGROUP1",
 *         PathRecommendations = new[]
 *         {
 *             new AzureNative.Security.Inputs.PathRecommendationArgs
 *             {
 *                 Action = "Recommended",
 *                 Common = true,
 *                 ConfigurationStatus = "Configured",
 *                 FileType = "Exe",
 *                 Path = "[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0",
 *                 PublisherInfo = new AzureNative.Security.Inputs.PublisherInfoArgs
 *                 {
 *                     BinaryName = "*",
 *                     ProductName = "*",
 *                     PublisherName = "O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US",
 *                     Version = "0.0.0.0",
 *                 },
 *                 Type = "PublisherSignature",
 *                 UserSids = new[]
 *                 {
 *                     "S-1-1-0",
 *                 },
 *                 Usernames = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.UserRecommendationArgs
 *                     {
 *                         RecommendationAction = "Recommended",
 *                         Username = "Everyone",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Security.Inputs.PathRecommendationArgs
 *             {
 *                 Action = "Recommended",
 *                 Common = true,
 *                 ConfigurationStatus = "Configured",
 *                 FileType = "Exe",
 *                 Path = "%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE",
 *                 PublisherInfo = new AzureNative.Security.Inputs.PublisherInfoArgs
 *                 {
 *                     BinaryName = "*",
 *                     ProductName = "MICROSOFT® COREXT",
 *                     PublisherName = "CN=MICROSOFT AZURE DEPENDENCY CODE SIGN",
 *                     Version = "0.0.0.0",
 *                 },
 *                 Type = "ProductSignature",
 *                 UserSids = new[]
 *                 {
 *                     "S-1-1-0",
 *                 },
 *                 Usernames = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.UserRecommendationArgs
 *                     {
 *                         RecommendationAction = "Recommended",
 *                         Username = "NT AUTHORITY\\SYSTEM",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Security.Inputs.PathRecommendationArgs
 *             {
 *                 Action = "Recommended",
 *                 Common = true,
 *                 ConfigurationStatus = "Configured",
 *                 FileType = "Exe",
 *                 Path = "%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE",
 *                 PublisherInfo = new AzureNative.Security.Inputs.PublisherInfoArgs
 *                 {
 *                     BinaryName = "*",
 *                     ProductName = "*",
 *                     PublisherName = "CN=MICROSOFT AZURE DEPENDENCY CODE SIGN",
 *                     Version = "0.0.0.0",
 *                 },
 *                 Type = "PublisherSignature",
 *                 UserSids = new[]
 *                 {
 *                     "S-1-1-0",
 *                 },
 *                 Usernames = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.UserRecommendationArgs
 *                     {
 *                         RecommendationAction = "Recommended",
 *                         Username = "NT AUTHORITY\\SYSTEM",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Security.Inputs.PathRecommendationArgs
 *             {
 *                 Action = "Add",
 *                 Common = true,
 *                 Path = "C:\\directory\\file.exe",
 *                 Type = "File",
 *             },
 *         },
 *         ProtectionMode = new AzureNative.Security.Inputs.ProtectionModeArgs
 *         {
 *             Exe = "Audit",
 *             Msi = "None",
 *             Script = "None",
 *         },
 *         VmRecommendations = new[]
 *         {
 *             new AzureNative.Security.Inputs.VmRecommendationArgs
 *             {
 *                 ConfigurationStatus = "Configured",
 *                 EnforcementSupport = "Supported",
 *                 RecommendationAction = "Recommended",
 *                 ResourceId = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090",
 *             },
 *             new AzureNative.Security.Inputs.VmRecommendationArgs
 *             {
 *                 ConfigurationStatus = "Configured",
 *                 EnforcementSupport = "Supported",
 *                 RecommendationAction = "Recommended",
 *                 ResourceId = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAdaptiveApplicationControl(ctx, "adaptiveApplicationControl", &security.AdaptiveApplicationControlArgs{
 * 			AscLocation:     pulumi.String("centralus"),
 * 			EnforcementMode: pulumi.String("Audit"),
 * 			GroupName:       pulumi.String("ERELGROUP1"),
 * 			PathRecommendations: security.PathRecommendationArray{
 * 				&security.PathRecommendationArgs{
 * 					Action:              pulumi.String("Recommended"),
 * 					Common:              pulumi.Bool(true),
 * 					ConfigurationStatus: pulumi.String("Configured"),
 * 					FileType:            pulumi.String("Exe"),
 * 					Path:                pulumi.String("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0"),
 * 					PublisherInfo: &security.PublisherInfoArgs{
 * 						BinaryName:    pulumi.String("*"),
 * 						ProductName:   pulumi.String("*"),
 * 						PublisherName: pulumi.String("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US"),
 * 						Version:       pulumi.String("0.0.0.0"),
 * 					},
 * 					Type: pulumi.String("PublisherSignature"),
 * 					UserSids: pulumi.StringArray{
 * 						pulumi.String("S-1-1-0"),
 * 					},
 * 					Usernames: security.UserRecommendationArray{
 * 						&security.UserRecommendationArgs{
 * 							RecommendationAction: pulumi.String("Recommended"),
 * 							Username:             pulumi.String("Everyone"),
 * 						},
 * 					},
 * 				},
 * 				&security.PathRecommendationArgs{
 * 					Action:              pulumi.String("Recommended"),
 * 					Common:              pulumi.Bool(true),
 * 					ConfigurationStatus: pulumi.String("Configured"),
 * 					FileType:            pulumi.String("Exe"),
 * 					Path:                pulumi.String("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE"),
 * 					PublisherInfo: &security.PublisherInfoArgs{
 * 						BinaryName:    pulumi.String("*"),
 * 						ProductName:   pulumi.String("MICROSOFT® COREXT"),
 * 						PublisherName: pulumi.String("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
 * 						Version:       pulumi.String("0.0.0.0"),
 * 					},
 * 					Type: pulumi.String("ProductSignature"),
 * 					UserSids: pulumi.StringArray{
 * 						pulumi.String("S-1-1-0"),
 * 					},
 * 					Usernames: security.UserRecommendationArray{
 * 						&security.UserRecommendationArgs{
 * 							RecommendationAction: pulumi.String("Recommended"),
 * 							Username:             pulumi.String("NT AUTHORITY\\SYSTEM"),
 * 						},
 * 					},
 * 				},
 * 				&security.PathRecommendationArgs{
 * 					Action:              pulumi.String("Recommended"),
 * 					Common:              pulumi.Bool(true),
 * 					ConfigurationStatus: pulumi.String("Configured"),
 * 					FileType:            pulumi.String("Exe"),
 * 					Path:                pulumi.String("%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE"),
 * 					PublisherInfo: &security.PublisherInfoArgs{
 * 						BinaryName:    pulumi.String("*"),
 * 						ProductName:   pulumi.String("*"),
 * 						PublisherName: pulumi.String("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
 * 						Version:       pulumi.String("0.0.0.0"),
 * 					},
 * 					Type: pulumi.String("PublisherSignature"),
 * 					UserSids: pulumi.StringArray{
 * 						pulumi.String("S-1-1-0"),
 * 					},
 * 					Usernames: security.UserRecommendationArray{
 * 						&security.UserRecommendationArgs{
 * 							RecommendationAction: pulumi.String("Recommended"),
 * 							Username:             pulumi.String("NT AUTHORITY\\SYSTEM"),
 * 						},
 * 					},
 * 				},
 * 				&security.PathRecommendationArgs{
 * 					Action: pulumi.String("Add"),
 * 					Common: pulumi.Bool(true),
 * 					Path:   pulumi.String("C:\\directory\\file.exe"),
 * 					Type:   pulumi.String("File"),
 * 				},
 * 			},
 * 			ProtectionMode: &security.ProtectionModeArgs{
 * 				Exe:    pulumi.String("Audit"),
 * 				Msi:    pulumi.String("None"),
 * 				Script: pulumi.String("None"),
 * 			},
 * 			VmRecommendations: security.VmRecommendationArray{
 * 				&security.VmRecommendationArgs{
 * 					ConfigurationStatus:  pulumi.String("Configured"),
 * 					EnforcementSupport:   pulumi.String("Supported"),
 * 					RecommendationAction: pulumi.String("Recommended"),
 * 					ResourceId:           pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090"),
 * 				},
 * 				&security.VmRecommendationArgs{
 * 					ConfigurationStatus:  pulumi.String("Configured"),
 * 					EnforcementSupport:   pulumi.String("Supported"),
 * 					RecommendationAction: pulumi.String("Recommended"),
 * 					ResourceId:           pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AdaptiveApplicationControl;
 * import com.pulumi.azurenative.security.AdaptiveApplicationControlArgs;
 * import com.pulumi.azurenative.security.inputs.PathRecommendationArgs;
 * import com.pulumi.azurenative.security.inputs.PublisherInfoArgs;
 * import com.pulumi.azurenative.security.inputs.ProtectionModeArgs;
 * import com.pulumi.azurenative.security.inputs.VmRecommendationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adaptiveApplicationControl = new AdaptiveApplicationControl("adaptiveApplicationControl", AdaptiveApplicationControlArgs.builder()
 *             .ascLocation("centralus")
 *             .enforcementMode("Audit")
 *             .groupName("ERELGROUP1")
 *             .pathRecommendations(
 *                 PathRecommendationArgs.builder()
 *                     .action("Recommended")
 *                     .common(true)
 *                     .configurationStatus("Configured")
 *                     .fileType("Exe")
 *                     .path("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0")
 *                     .publisherInfo(PublisherInfoArgs.builder()
 *                         .binaryName("*")
 *                         .productName("*")
 *                         .publisherName("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US")
 *                         .version("0.0.0.0")
 *                         .build())
 *                     .type("PublisherSignature")
 *                     .userSids("S-1-1-0")
 *                     .usernames(UserRecommendationArgs.builder()
 *                         .recommendationAction("Recommended")
 *                         .username("Everyone")
 *                         .build())
 *                     .build(),
 *                 PathRecommendationArgs.builder()
 *                     .action("Recommended")
 *                     .common(true)
 *                     .configurationStatus("Configured")
 *                     .fileType("Exe")
 *                     .path("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE")
 *                     .publisherInfo(PublisherInfoArgs.builder()
 *                         .binaryName("*")
 *                         .productName("MICROSOFT® COREXT")
 *                         .publisherName("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN")
 *                         .version("0.0.0.0")
 *                         .build())
 *                     .type("ProductSignature")
 *                     .userSids("S-1-1-0")
 *                     .usernames(UserRecommendationArgs.builder()
 *                         .recommendationAction("Recommended")
 *                         .username("NT AUTHORITY\\SYSTEM")
 *                         .build())
 *                     .build(),
 *                 PathRecommendationArgs.builder()
 *                     .action("Recommended")
 *                     .common(true)
 *                     .configurationStatus("Configured")
 *                     .fileType("Exe")
 *                     .path("%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE")
 *                     .publisherInfo(PublisherInfoArgs.builder()
 *                         .binaryName("*")
 *                         .productName("*")
 *                         .publisherName("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN")
 *                         .version("0.0.0.0")
 *                         .build())
 *                     .type("PublisherSignature")
 *                     .userSids("S-1-1-0")
 *                     .usernames(UserRecommendationArgs.builder()
 *                         .recommendationAction("Recommended")
 *                         .username("NT AUTHORITY\\SYSTEM")
 *                         .build())
 *                     .build(),
 *                 PathRecommendationArgs.builder()
 *                     .action("Add")
 *                     .common(true)
 *                     .path("C:\\directory\\file.exe")
 *                     .type("File")
 *                     .build())
 *             .protectionMode(ProtectionModeArgs.builder()
 *                 .exe("Audit")
 *                 .msi("None")
 *                 .script("None")
 *                 .build())
 *             .vmRecommendations(
 *                 VmRecommendationArgs.builder()
 *                     .configurationStatus("Configured")
 *                     .enforcementSupport("Supported")
 *                     .recommendationAction("Recommended")
 *                     .resourceId("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090")
 *                     .build(),
 *                 VmRecommendationArgs.builder()
 *                     .configurationStatus("Configured")
 *                     .enforcementSupport("Supported")
 *                     .recommendationAction("Recommended")
 *                     .resourceId("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AdaptiveApplicationControl ERELGROUP1 /subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/applicationWhitelistings/{groupName}
 * ```
 */
public class AdaptiveApplicationControl internal constructor(
    override val javaResource: com.pulumi.azurenative.security.AdaptiveApplicationControl,
) : KotlinCustomResource(javaResource, AdaptiveApplicationControlMapper) {
    /**
     * The configuration status of the machines group or machine or rule
     */
    public val configurationStatus: Output<String>
        get() = javaResource.configurationStatus().applyValue({ args0 -> args0 })

    /**
     * The application control policy enforcement/protection mode of the machine group
     */
    public val enforcementMode: Output<String>?
        get() = javaResource.enforcementMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val issues: Output<List<AdaptiveApplicationControlIssueSummaryResponse>>
        get() = javaResource.issues().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    adaptiveApplicationControlIssueSummaryResponseToKotlin(args0)
                })
            })
        })

    /**
     * Location where the resource is stored
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val pathRecommendations: Output<List<PathRecommendationResponse>>?
        get() = javaResource.pathRecommendations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        pathRecommendationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
     */
    public val protectionMode: Output<ProtectionModeResponse>?
        get() = javaResource.protectionMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> protectionModeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The initial recommendation status of the machine group or machine
     */
    public val recommendationStatus: Output<String>
        get() = javaResource.recommendationStatus().applyValue({ args0 -> args0 })

    /**
     * The source type of the machine group
     */
    public val sourceSystem: Output<String>
        get() = javaResource.sourceSystem().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    public val vmRecommendations: Output<List<VmRecommendationResponse>>?
        get() = javaResource.vmRecommendations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vmRecommendationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object AdaptiveApplicationControlMapper : ResourceMapper<AdaptiveApplicationControl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.AdaptiveApplicationControl::class == javaResource::class

    override fun map(javaResource: Resource): AdaptiveApplicationControl =
        AdaptiveApplicationControl(
            javaResource as
                com.pulumi.azurenative.security.AdaptiveApplicationControl,
        )
}

/**
 * @see [AdaptiveApplicationControl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AdaptiveApplicationControl].
 */
public suspend fun adaptiveApplicationControl(
    name: String,
    block: suspend AdaptiveApplicationControlResourceBuilder.() -> Unit,
): AdaptiveApplicationControl {
    val builder = AdaptiveApplicationControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AdaptiveApplicationControl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun adaptiveApplicationControl(name: String): AdaptiveApplicationControl {
    val builder = AdaptiveApplicationControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
