@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AdaptiveApplicationControlArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.PathRecommendationArgs
import com.pulumi.azurenative.security.kotlin.inputs.PathRecommendationArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.ProtectionModeArgs
import com.pulumi.azurenative.security.kotlin.inputs.ProtectionModeArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.VmRecommendationArgs
import com.pulumi.azurenative.security.kotlin.inputs.VmRecommendationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2020-01-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2015-06-01-preview.
 * ## Example Usage
 * ### Update an application control machine group by adding a new application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adaptiveApplicationControl = new AzureNative.Security.AdaptiveApplicationControl("adaptiveApplicationControl", new()
 *     {
 *         AscLocation = "centralus",
 *         EnforcementMode = "Audit",
 *         GroupName = "ERELGROUP1",
 *         PathRecommendations = new[]
 *         {
 *             new AzureNative.Security.Inputs.PathRecommendationArgs
 *             {
 *                 Action = "Recommended",
 *                 Common = true,
 *                 ConfigurationStatus = "Configured",
 *                 FileType = "Exe",
 *                 Path = "[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0",
 *                 PublisherInfo = new AzureNative.Security.Inputs.PublisherInfoArgs
 *                 {
 *                     BinaryName = "*",
 *                     ProductName = "*",
 *                     PublisherName = "O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US",
 *                     Version = "0.0.0.0",
 *                 },
 *                 Type = "PublisherSignature",
 *                 UserSids = new[]
 *                 {
 *                     "S-1-1-0",
 *                 },
 *                 Usernames = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.UserRecommendationArgs
 *                     {
 *                         RecommendationAction = "Recommended",
 *                         Username = "Everyone",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Security.Inputs.PathRecommendationArgs
 *             {
 *                 Action = "Recommended",
 *                 Common = true,
 *                 ConfigurationStatus = "Configured",
 *                 FileType = "Exe",
 *                 Path = "%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE",
 *                 PublisherInfo = new AzureNative.Security.Inputs.PublisherInfoArgs
 *                 {
 *                     BinaryName = "*",
 *                     ProductName = "MICROSOFT® COREXT",
 *                     PublisherName = "CN=MICROSOFT AZURE DEPENDENCY CODE SIGN",
 *                     Version = "0.0.0.0",
 *                 },
 *                 Type = "ProductSignature",
 *                 UserSids = new[]
 *                 {
 *                     "S-1-1-0",
 *                 },
 *                 Usernames = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.UserRecommendationArgs
 *                     {
 *                         RecommendationAction = "Recommended",
 *                         Username = "NT AUTHORITY\\SYSTEM",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Security.Inputs.PathRecommendationArgs
 *             {
 *                 Action = "Recommended",
 *                 Common = true,
 *                 ConfigurationStatus = "Configured",
 *                 FileType = "Exe",
 *                 Path = "%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE",
 *                 PublisherInfo = new AzureNative.Security.Inputs.PublisherInfoArgs
 *                 {
 *                     BinaryName = "*",
 *                     ProductName = "*",
 *                     PublisherName = "CN=MICROSOFT AZURE DEPENDENCY CODE SIGN",
 *                     Version = "0.0.0.0",
 *                 },
 *                 Type = "PublisherSignature",
 *                 UserSids = new[]
 *                 {
 *                     "S-1-1-0",
 *                 },
 *                 Usernames = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.UserRecommendationArgs
 *                     {
 *                         RecommendationAction = "Recommended",
 *                         Username = "NT AUTHORITY\\SYSTEM",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Security.Inputs.PathRecommendationArgs
 *             {
 *                 Action = "Add",
 *                 Common = true,
 *                 Path = "C:\\directory\\file.exe",
 *                 Type = "File",
 *             },
 *         },
 *         ProtectionMode = new AzureNative.Security.Inputs.ProtectionModeArgs
 *         {
 *             Exe = "Audit",
 *             Msi = "None",
 *             Script = "None",
 *         },
 *         VmRecommendations = new[]
 *         {
 *             new AzureNative.Security.Inputs.VmRecommendationArgs
 *             {
 *                 ConfigurationStatus = "Configured",
 *                 EnforcementSupport = "Supported",
 *                 RecommendationAction = "Recommended",
 *                 ResourceId = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090",
 *             },
 *             new AzureNative.Security.Inputs.VmRecommendationArgs
 *             {
 *                 ConfigurationStatus = "Configured",
 *                 EnforcementSupport = "Supported",
 *                 RecommendationAction = "Recommended",
 *                 ResourceId = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAdaptiveApplicationControl(ctx, "adaptiveApplicationControl", &security.AdaptiveApplicationControlArgs{
 * 			AscLocation:     pulumi.String("centralus"),
 * 			EnforcementMode: pulumi.String("Audit"),
 * 			GroupName:       pulumi.String("ERELGROUP1"),
 * 			PathRecommendations: security.PathRecommendationArray{
 * 				&security.PathRecommendationArgs{
 * 					Action:              pulumi.String("Recommended"),
 * 					Common:              pulumi.Bool(true),
 * 					ConfigurationStatus: pulumi.String("Configured"),
 * 					FileType:            pulumi.String("Exe"),
 * 					Path:                pulumi.String("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0"),
 * 					PublisherInfo: &security.PublisherInfoArgs{
 * 						BinaryName:    pulumi.String("*"),
 * 						ProductName:   pulumi.String("*"),
 * 						PublisherName: pulumi.String("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US"),
 * 						Version:       pulumi.String("0.0.0.0"),
 * 					},
 * 					Type: pulumi.String("PublisherSignature"),
 * 					UserSids: pulumi.StringArray{
 * 						pulumi.String("S-1-1-0"),
 * 					},
 * 					Usernames: security.UserRecommendationArray{
 * 						&security.UserRecommendationArgs{
 * 							RecommendationAction: pulumi.String("Recommended"),
 * 							Username:             pulumi.String("Everyone"),
 * 						},
 * 					},
 * 				},
 * 				&security.PathRecommendationArgs{
 * 					Action:              pulumi.String("Recommended"),
 * 					Common:              pulumi.Bool(true),
 * 					ConfigurationStatus: pulumi.String("Configured"),
 * 					FileType:            pulumi.String("Exe"),
 * 					Path:                pulumi.String("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE"),
 * 					PublisherInfo: &security.PublisherInfoArgs{
 * 						BinaryName:    pulumi.String("*"),
 * 						ProductName:   pulumi.String("MICROSOFT® COREXT"),
 * 						PublisherName: pulumi.String("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
 * 						Version:       pulumi.String("0.0.0.0"),
 * 					},
 * 					Type: pulumi.String("ProductSignature"),
 * 					UserSids: pulumi.StringArray{
 * 						pulumi.String("S-1-1-0"),
 * 					},
 * 					Usernames: security.UserRecommendationArray{
 * 						&security.UserRecommendationArgs{
 * 							RecommendationAction: pulumi.String("Recommended"),
 * 							Username:             pulumi.String("NT AUTHORITY\\SYSTEM"),
 * 						},
 * 					},
 * 				},
 * 				&security.PathRecommendationArgs{
 * 					Action:              pulumi.String("Recommended"),
 * 					Common:              pulumi.Bool(true),
 * 					ConfigurationStatus: pulumi.String("Configured"),
 * 					FileType:            pulumi.String("Exe"),
 * 					Path:                pulumi.String("%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE"),
 * 					PublisherInfo: &security.PublisherInfoArgs{
 * 						BinaryName:    pulumi.String("*"),
 * 						ProductName:   pulumi.String("*"),
 * 						PublisherName: pulumi.String("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN"),
 * 						Version:       pulumi.String("0.0.0.0"),
 * 					},
 * 					Type: pulumi.String("PublisherSignature"),
 * 					UserSids: pulumi.StringArray{
 * 						pulumi.String("S-1-1-0"),
 * 					},
 * 					Usernames: security.UserRecommendationArray{
 * 						&security.UserRecommendationArgs{
 * 							RecommendationAction: pulumi.String("Recommended"),
 * 							Username:             pulumi.String("NT AUTHORITY\\SYSTEM"),
 * 						},
 * 					},
 * 				},
 * 				&security.PathRecommendationArgs{
 * 					Action: pulumi.String("Add"),
 * 					Common: pulumi.Bool(true),
 * 					Path:   pulumi.String("C:\\directory\\file.exe"),
 * 					Type:   pulumi.String("File"),
 * 				},
 * 			},
 * 			ProtectionMode: &security.ProtectionModeArgs{
 * 				Exe:    pulumi.String("Audit"),
 * 				Msi:    pulumi.String("None"),
 * 				Script: pulumi.String("None"),
 * 			},
 * 			VmRecommendations: security.VmRecommendationArray{
 * 				&security.VmRecommendationArgs{
 * 					ConfigurationStatus:  pulumi.String("Configured"),
 * 					EnforcementSupport:   pulumi.String("Supported"),
 * 					RecommendationAction: pulumi.String("Recommended"),
 * 					ResourceId:           pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090"),
 * 				},
 * 				&security.VmRecommendationArgs{
 * 					ConfigurationStatus:  pulumi.String("Configured"),
 * 					EnforcementSupport:   pulumi.String("Supported"),
 * 					RecommendationAction: pulumi.String("Recommended"),
 * 					ResourceId:           pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AdaptiveApplicationControl;
 * import com.pulumi.azurenative.security.AdaptiveApplicationControlArgs;
 * import com.pulumi.azurenative.security.inputs.PathRecommendationArgs;
 * import com.pulumi.azurenative.security.inputs.PublisherInfoArgs;
 * import com.pulumi.azurenative.security.inputs.ProtectionModeArgs;
 * import com.pulumi.azurenative.security.inputs.VmRecommendationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adaptiveApplicationControl = new AdaptiveApplicationControl("adaptiveApplicationControl", AdaptiveApplicationControlArgs.builder()
 *             .ascLocation("centralus")
 *             .enforcementMode("Audit")
 *             .groupName("ERELGROUP1")
 *             .pathRecommendations(
 *                 PathRecommendationArgs.builder()
 *                     .action("Recommended")
 *                     .common(true)
 *                     .configurationStatus("Configured")
 *                     .fileType("Exe")
 *                     .path("[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0")
 *                     .publisherInfo(PublisherInfoArgs.builder()
 *                         .binaryName("*")
 *                         .productName("*")
 *                         .publisherName("O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US")
 *                         .version("0.0.0.0")
 *                         .build())
 *                     .type("PublisherSignature")
 *                     .userSids("S-1-1-0")
 *                     .usernames(UserRecommendationArgs.builder()
 *                         .recommendationAction("Recommended")
 *                         .username("Everyone")
 *                         .build())
 *                     .build(),
 *                 PathRecommendationArgs.builder()
 *                     .action("Recommended")
 *                     .common(true)
 *                     .configurationStatus("Configured")
 *                     .fileType("Exe")
 *                     .path("%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE")
 *                     .publisherInfo(PublisherInfoArgs.builder()
 *                         .binaryName("*")
 *                         .productName("MICROSOFT® COREXT")
 *                         .publisherName("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN")
 *                         .version("0.0.0.0")
 *                         .build())
 *                     .type("ProductSignature")
 *                     .userSids("S-1-1-0")
 *                     .usernames(UserRecommendationArgs.builder()
 *                         .recommendationAction("Recommended")
 *                         .username("NT AUTHORITY\\SYSTEM")
 *                         .build())
 *                     .build(),
 *                 PathRecommendationArgs.builder()
 *                     .action("Recommended")
 *                     .common(true)
 *                     .configurationStatus("Configured")
 *                     .fileType("Exe")
 *                     .path("%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE")
 *                     .publisherInfo(PublisherInfoArgs.builder()
 *                         .binaryName("*")
 *                         .productName("*")
 *                         .publisherName("CN=MICROSOFT AZURE DEPENDENCY CODE SIGN")
 *                         .version("0.0.0.0")
 *                         .build())
 *                     .type("PublisherSignature")
 *                     .userSids("S-1-1-0")
 *                     .usernames(UserRecommendationArgs.builder()
 *                         .recommendationAction("Recommended")
 *                         .username("NT AUTHORITY\\SYSTEM")
 *                         .build())
 *                     .build(),
 *                 PathRecommendationArgs.builder()
 *                     .action("Add")
 *                     .common(true)
 *                     .path("C:\\directory\\file.exe")
 *                     .type("File")
 *                     .build())
 *             .protectionMode(ProtectionModeArgs.builder()
 *                 .exe("Audit")
 *                 .msi("None")
 *                 .script("None")
 *                 .build())
 *             .vmRecommendations(
 *                 VmRecommendationArgs.builder()
 *                     .configurationStatus("Configured")
 *                     .enforcementSupport("Supported")
 *                     .recommendationAction("Recommended")
 *                     .resourceId("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090")
 *                     .build(),
 *                 VmRecommendationArgs.builder()
 *                     .configurationStatus("Configured")
 *                     .enforcementSupport("Supported")
 *                     .recommendationAction("Recommended")
 *                     .resourceId("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AdaptiveApplicationControl ERELGROUP1 /subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/applicationWhitelistings/{groupName}
 * ```
 * @property ascLocation The location where ASC stores the data of the subscription. can be retrieved from Get locations
 * @property enforcementMode The application control policy enforcement/protection mode of the machine group
 * @property groupName Name of an application control machine group
 * @property pathRecommendations
 * @property protectionMode The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
 * @property vmRecommendations
 */
public data class AdaptiveApplicationControlArgs(
    public val ascLocation: Output<String>? = null,
    public val enforcementMode: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val pathRecommendations: Output<List<PathRecommendationArgs>>? = null,
    public val protectionMode: Output<ProtectionModeArgs>? = null,
    public val vmRecommendations: Output<List<VmRecommendationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AdaptiveApplicationControlArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AdaptiveApplicationControlArgs =
        com.pulumi.azurenative.security.AdaptiveApplicationControlArgs.builder()
            .ascLocation(ascLocation?.applyValue({ args0 -> args0 }))
            .enforcementMode(enforcementMode?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .pathRecommendations(
                pathRecommendations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protectionMode(protectionMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmRecommendations(
                vmRecommendations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AdaptiveApplicationControlArgs].
 */
@PulumiTagMarker
public class AdaptiveApplicationControlArgsBuilder internal constructor() {
    private var ascLocation: Output<String>? = null

    private var enforcementMode: Output<String>? = null

    private var groupName: Output<String>? = null

    private var pathRecommendations: Output<List<PathRecommendationArgs>>? = null

    private var protectionMode: Output<ProtectionModeArgs>? = null

    private var vmRecommendations: Output<List<VmRecommendationArgs>>? = null

    /**
     * @param value The location where ASC stores the data of the subscription. can be retrieved from Get locations
     */
    @JvmName("lhpqihljqngvwshq")
    public suspend fun ascLocation(`value`: Output<String>) {
        this.ascLocation = value
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("twdvldpksnppwejx")
    public suspend fun enforcementMode(`value`: Output<String>) {
        this.enforcementMode = value
    }

    /**
     * @param value Name of an application control machine group
     */
    @JvmName("fndkgqcujqhmhtig")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value
     */
    @JvmName("ymrrqcigvernydmr")
    public suspend fun pathRecommendations(`value`: Output<List<PathRecommendationArgs>>) {
        this.pathRecommendations = value
    }

    @JvmName("yutombyujevwbodj")
    public suspend fun pathRecommendations(vararg values: Output<PathRecommendationArgs>) {
        this.pathRecommendations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rcrchtcgqfqmjrbr")
    public suspend fun pathRecommendations(values: List<Output<PathRecommendationArgs>>) {
        this.pathRecommendations = Output.all(values)
    }

    /**
     * @param value The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
     */
    @JvmName("ftdfovsqueituvpl")
    public suspend fun protectionMode(`value`: Output<ProtectionModeArgs>) {
        this.protectionMode = value
    }

    /**
     * @param value
     */
    @JvmName("bfqsjighidtpjywq")
    public suspend fun vmRecommendations(`value`: Output<List<VmRecommendationArgs>>) {
        this.vmRecommendations = value
    }

    @JvmName("vrpiphhbjcueedwb")
    public suspend fun vmRecommendations(vararg values: Output<VmRecommendationArgs>) {
        this.vmRecommendations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xjmjecivrlhqlnce")
    public suspend fun vmRecommendations(values: List<Output<VmRecommendationArgs>>) {
        this.vmRecommendations = Output.all(values)
    }

    /**
     * @param value The location where ASC stores the data of the subscription. can be retrieved from Get locations
     */
    @JvmName("mshsvijccljifcii")
    public suspend fun ascLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ascLocation = mapped
    }

    /**
     * @param value The application control policy enforcement/protection mode of the machine group
     */
    @JvmName("rjhvtvxpwcdolfdh")
    public suspend fun enforcementMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforcementMode = mapped
    }

    /**
     * @param value Name of an application control machine group
     */
    @JvmName("hfaispglfbnruwsx")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("nwtyoudbdqxhsfgm")
    public suspend fun pathRecommendations(`value`: List<PathRecommendationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathRecommendations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("epmaehuvfvblnhgu")
    public suspend fun pathRecommendations(argument: List<suspend PathRecommendationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PathRecommendationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pathRecommendations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gnwuniyjmghrkjtn")
    public suspend fun pathRecommendations(vararg argument: suspend PathRecommendationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PathRecommendationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pathRecommendations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sjtdembtcabqbjaf")
    public suspend fun pathRecommendations(argument: suspend PathRecommendationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PathRecommendationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pathRecommendations = mapped
    }

    /**
     * @param values
     */
    @JvmName("tjfiqtyuqngowmsh")
    public suspend fun pathRecommendations(vararg values: PathRecommendationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pathRecommendations = mapped
    }

    /**
     * @param value The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
     */
    @JvmName("cudyojielhfutxbs")
    public suspend fun protectionMode(`value`: ProtectionModeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionMode = mapped
    }

    /**
     * @param argument The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
     */
    @JvmName("rxwadagtwptqhxra")
    public suspend fun protectionMode(argument: suspend ProtectionModeArgsBuilder.() -> Unit) {
        val toBeMapped = ProtectionModeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protectionMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("jiletqcpyrrwrlrq")
    public suspend fun vmRecommendations(`value`: List<VmRecommendationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmRecommendations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kwndbdyferfixejm")
    public suspend fun vmRecommendations(argument: List<suspend VmRecommendationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VmRecommendationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vmRecommendations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ptfwvndebyfjecac")
    public suspend fun vmRecommendations(vararg argument: suspend VmRecommendationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VmRecommendationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vmRecommendations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("baenakntsawxlsab")
    public suspend fun vmRecommendations(argument: suspend VmRecommendationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VmRecommendationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vmRecommendations = mapped
    }

    /**
     * @param values
     */
    @JvmName("niansohsbvcusrck")
    public suspend fun vmRecommendations(vararg values: VmRecommendationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmRecommendations = mapped
    }

    internal fun build(): AdaptiveApplicationControlArgs = AdaptiveApplicationControlArgs(
        ascLocation = ascLocation,
        enforcementMode = enforcementMode,
        groupName = groupName,
        pathRecommendations = pathRecommendations,
        protectionMode = protectionMode,
        vmRecommendations = vmRecommendations,
    )
}
