@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.SuppressionAlertsScopeResponse
import com.pulumi.azurenative.security.kotlin.outputs.SuppressionAlertsScopeResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlertsSuppressionRule].
 */
@PulumiTagMarker
public class AlertsSuppressionRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlertsSuppressionRuleArgs = AlertsSuppressionRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlertsSuppressionRuleArgsBuilder.() -> Unit) {
        val builder = AlertsSuppressionRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlertsSuppressionRule {
        val builtJavaResource =
            com.pulumi.azurenative.security.AlertsSuppressionRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AlertsSuppressionRule(builtJavaResource)
    }
}

/**
 * Describes the suppression rule
 * Azure REST API version: 2019-01-01-preview. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * ## Example Usage
 * ### Update or create suppression rule for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertsSuppressionRule = new AzureNative.Security.AlertsSuppressionRule("alertsSuppressionRule", new()
 *     {
 *         AlertType = "IpAnomaly",
 *         AlertsSuppressionRuleName = "dismissIpAnomalyAlerts",
 *         Comment = "Test VM",
 *         ExpirationDateUtc = "2019-12-01T19:50:47.083633Z",
 *         Reason = "FalsePositive",
 *         State = AzureNative.Security.RuleState.Enabled,
 *         SuppressionAlertsScope = new AzureNative.Security.Inputs.SuppressionAlertsScopeArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Security.Inputs.ScopeElementArgs
 *                 {
 *                     Field = "entities.ip.address",
 *                 },
 *                 new AzureNative.Security.Inputs.ScopeElementArgs
 *                 {
 *                     Field = "entities.process.commandline",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAlertsSuppressionRule(ctx, "alertsSuppressionRule", &security.AlertsSuppressionRuleArgs{
 * 			AlertType:                 pulumi.String("IpAnomaly"),
 * 			AlertsSuppressionRuleName: pulumi.String("dismissIpAnomalyAlerts"),
 * 			Comment:                   pulumi.String("Test VM"),
 * 			ExpirationDateUtc:         pulumi.String("2019-12-01T19:50:47.083633Z"),
 * 			Reason:                    pulumi.String("FalsePositive"),
 * 			State:                     pulumi.String(security.RuleStateEnabled),
 * 			SuppressionAlertsScope: &security.SuppressionAlertsScopeArgs{
 * 				AllOf: security.ScopeElementArray{
 * 					&security.ScopeElementArgs{
 * 						Field: pulumi.String("entities.ip.address"),
 * 					},
 * 					&security.ScopeElementArgs{
 * 						Field: pulumi.String("entities.process.commandline"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AlertsSuppressionRule;
 * import com.pulumi.azurenative.security.AlertsSuppressionRuleArgs;
 * import com.pulumi.azurenative.security.inputs.SuppressionAlertsScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertsSuppressionRule = new AlertsSuppressionRule("alertsSuppressionRule", AlertsSuppressionRuleArgs.builder()
 *             .alertType("IpAnomaly")
 *             .alertsSuppressionRuleName("dismissIpAnomalyAlerts")
 *             .comment("Test VM")
 *             .expirationDateUtc("2019-12-01T19:50:47.083633Z")
 *             .reason("FalsePositive")
 *             .state("Enabled")
 *             .suppressionAlertsScope(SuppressionAlertsScopeArgs.builder()
 *                 .allOf(
 *                     ScopeElementArgs.builder()
 *                         .field("entities.ip.address")
 *                         .build(),
 *                     ScopeElementArgs.builder()
 *                         .field("entities.process.commandline")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AlertsSuppressionRule dismissIpAnomalyAlerts /subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules/{alertsSuppressionRuleName}
 * ```
 */
public class AlertsSuppressionRule internal constructor(
    override val javaResource: com.pulumi.azurenative.security.AlertsSuppressionRule,
) : KotlinCustomResource(javaResource, AlertsSuppressionRuleMapper) {
    /**
     * Type of the alert to automatically suppress. For all alert types, use '*'
     */
    public val alertType: Output<String>
        get() = javaResource.alertType().applyValue({ args0 -> args0 })

    /**
     * Any comment regarding the rule
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Expiration date of the rule, if value is not provided or provided as null there will no expiration at all
     */
    public val expirationDateUtc: Output<String>?
        get() = javaResource.expirationDateUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last time this rule was modified
     */
    public val lastModifiedUtc: Output<String>
        get() = javaResource.lastModifiedUtc().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The reason for dismissing the alert
     */
    public val reason: Output<String>
        get() = javaResource.reason().applyValue({ args0 -> args0 })

    /**
     * Possible states of the rule
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The suppression conditions
     */
    public val suppressionAlertsScope: Output<SuppressionAlertsScopeResponse>?
        get() = javaResource.suppressionAlertsScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AlertsSuppressionRuleMapper : ResourceMapper<AlertsSuppressionRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.AlertsSuppressionRule::class == javaResource::class

    override fun map(javaResource: Resource): AlertsSuppressionRule =
        AlertsSuppressionRule(javaResource as com.pulumi.azurenative.security.AlertsSuppressionRule)
}

/**
 * @see [AlertsSuppressionRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlertsSuppressionRule].
 */
public suspend fun alertsSuppressionRule(
    name: String,
    block: suspend AlertsSuppressionRuleResourceBuilder.() -> Unit,
): AlertsSuppressionRule {
    val builder = AlertsSuppressionRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlertsSuppressionRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alertsSuppressionRule(name: String): AlertsSuppressionRule {
    val builder = AlertsSuppressionRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
