@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.ApplicationArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.ApplicationSourceResourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Security Application over a given scope
 * Azure REST API version: 2022-07-01-preview. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * ## Example Usage
 * ### Create application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.Security.Application("application", new()
 *     {
 *         ApplicationId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         Description = "An application on critical recommendations",
 *         DisplayName = "Admin's application",
 *         SourceResourceType = AzureNative.Security.ApplicationSourceResourceType.Assessments,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewApplication(ctx, "application", &security.ApplicationArgs{
 * 			ApplicationId:      pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			Description:        pulumi.String("An application on critical recommendations"),
 * 			DisplayName:        pulumi.String("Admin's application"),
 * 			SourceResourceType: pulumi.String(security.ApplicationSourceResourceTypeAssessments),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Application;
 * import com.pulumi.azurenative.security.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .description("An application on critical recommendations")
 *             .displayName("Admin's application")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Application 1f3afdf9-d0c9-4c3d-847f-89da613e70a8 /subscriptions/{subscriptionId}/providers/Microsoft.Security/applications/{applicationId}
 * ```
 * @property applicationId The security Application key - unique key for the standard application
 * @property description description of the application
 * @property displayName display name of the application
 * @property sourceResourceType The application source, what it affects, e.g. Assessments
 */
public data class ApplicationArgs(
    public val applicationId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val sourceResourceType: Output<Either<String, ApplicationSourceResourceType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.ApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.ApplicationArgs =
        com.pulumi.azurenative.security.ApplicationArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .sourceResourceType(
                sourceResourceType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var sourceResourceType: Output<Either<String, ApplicationSourceResourceType>>? = null

    /**
     * @param value The security Application key - unique key for the standard application
     */
    @JvmName("jcpvxxdpkwvlfdxk")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value description of the application
     */
    @JvmName("gqdxkocvtivtwups")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value display name of the application
     */
    @JvmName("tabogfmmlwdhefmx")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The application source, what it affects, e.g. Assessments
     */
    @JvmName("rgfhojmkteefjwdf")
    public suspend fun sourceResourceType(`value`: Output<Either<String, ApplicationSourceResourceType>>) {
        this.sourceResourceType = value
    }

    /**
     * @param value The security Application key - unique key for the standard application
     */
    @JvmName("ddvvuadukfcrsboa")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value description of the application
     */
    @JvmName("awqqnrpngwbqbrkk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value display name of the application
     */
    @JvmName("mjxfnpaufhfrnayr")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The application source, what it affects, e.g. Assessments
     */
    @JvmName("wxollwrellqlesxj")
    public suspend fun sourceResourceType(`value`: Either<String, ApplicationSourceResourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    /**
     * @param value The application source, what it affects, e.g. Assessments
     */
    @JvmName("iwaocsnqxughqlim")
    public fun sourceResourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationSourceResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    /**
     * @param value The application source, what it affects, e.g. Assessments
     */
    @JvmName("inidyajdfyanwlgk")
    public fun sourceResourceType(`value`: ApplicationSourceResourceType) {
        val toBeMapped = Either.ofRight<String, ApplicationSourceResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationId = applicationId,
        description = description,
        displayName = displayName,
        sourceResourceType = sourceResourceType,
    )
}
