@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.AssessmentLinksResponse
import com.pulumi.azurenative.security.kotlin.outputs.AssessmentStatusResponseResponse
import com.pulumi.azurenative.security.kotlin.outputs.SecurityAssessmentMetadataPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.SecurityAssessmentPartnerDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.security.kotlin.outputs.AssessmentLinksResponse.Companion.toKotlin as assessmentLinksResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.AssessmentStatusResponseResponse.Companion.toKotlin as assessmentStatusResponseResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SecurityAssessmentMetadataPropertiesResponse.Companion.toKotlin as securityAssessmentMetadataPropertiesResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SecurityAssessmentPartnerDataResponse.Companion.toKotlin as securityAssessmentPartnerDataResponseToKotlin

/**
 * Builder for [Assessment].
 */
@PulumiTagMarker
public class AssessmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentArgs = AssessmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentArgsBuilder.() -> Unit) {
        val builder = AssessmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Assessment {
        val builtJavaResource = com.pulumi.azurenative.security.Assessment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Assessment(builtJavaResource)
    }
}

/**
 * Security assessment on a resource - response format
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2020-01-01.
 * ## Example Usage
 * ### Create security recommendation task on a resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessment = new AzureNative.Security.Assessment("assessment", new()
 *     {
 *         AssessmentName = "8bb8be0a-6010-4789-812f-e4d661c4ed0e",
 *         ResourceDetails = new AzureNative.Security.Inputs.AzureResourceDetailsArgs
 *         {
 *             Source = "Azure",
 *         },
 *         ResourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.Compute/virtualMachineScaleSets/vmss2",
 *         Status = new AzureNative.Security.Inputs.AssessmentStatusArgs
 *         {
 *             Code = AzureNative.Security.AssessmentStatusCode.Healthy,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssessment(ctx, "assessment", &security.AssessmentArgs{
 * 			AssessmentName: pulumi.String("8bb8be0a-6010-4789-812f-e4d661c4ed0e"),
 * 			ResourceDetails: security.AzureResourceDetails{
 * 				Source: "Azure",
 * 			},
 * 			ResourceId: pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.Compute/virtualMachineScaleSets/vmss2"),
 * 			Status: &security.AssessmentStatusArgs{
 * 				Code: pulumi.String(security.AssessmentStatusCodeHealthy),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Assessment;
 * import com.pulumi.azurenative.security.AssessmentArgs;
 * import com.pulumi.azurenative.security.inputs.AssessmentStatusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessment = new Assessment("assessment", AssessmentArgs.builder()
 *             .assessmentName("8bb8be0a-6010-4789-812f-e4d661c4ed0e")
 *             .resourceDetails(AzureResourceDetailsArgs.builder()
 *                 .source("Azure")
 *                 .build())
 *             .resourceId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.Compute/virtualMachineScaleSets/vmss2")
 *             .status(AssessmentStatusArgs.builder()
 *                 .code("Healthy")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Assessment 8bb8be0a-6010-4789-812f-e4d661c4ed0e /{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}
 * ```
 */
public class Assessment internal constructor(
    override val javaResource: com.pulumi.azurenative.security.Assessment,
) : KotlinCustomResource(javaResource, AssessmentMapper) {
    /**
     * Additional data regarding the assessment
     */
    public val additionalData: Output<Map<String, String>>?
        get() = javaResource.additionalData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * User friendly display name of the assessment
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Links relevant to the assessment
     */
    public val links: Output<AssessmentLinksResponse>
        get() = javaResource.links().applyValue({ args0 ->
            args0.let({ args0 ->
                assessmentLinksResponseToKotlin(args0)
            })
        })

    /**
     * Describes properties of an assessment metadata.
     */
    public val metadata: Output<SecurityAssessmentMetadataPropertiesResponse>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    securityAssessmentMetadataPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Data regarding 3rd party partner integration
     */
    public val partnersData: Output<SecurityAssessmentPartnerDataResponse>?
        get() = javaResource.partnersData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    securityAssessmentPartnerDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Details of the resource that was assessed
     */
    public val resourceDetails: Output<Any>
        get() = javaResource.resourceDetails().applyValue({ args0 -> args0 })

    /**
     * The result of the assessment
     */
    public val status: Output<AssessmentStatusResponseResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                assessmentStatusResponseResponseToKotlin(args0)
            })
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AssessmentMapper : ResourceMapper<Assessment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.Assessment::class == javaResource::class

    override fun map(javaResource: Resource): Assessment = Assessment(
        javaResource as
            com.pulumi.azurenative.security.Assessment,
    )
}

/**
 * @see [Assessment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Assessment].
 */
public suspend fun assessment(name: String, block: suspend AssessmentResourceBuilder.() -> Unit): Assessment {
    val builder = AssessmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Assessment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessment(name: String): Assessment {
    val builder = AssessmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
