@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AzureServersSetting].
 */
@PulumiTagMarker
public class AzureServersSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureServersSettingArgs = AzureServersSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureServersSettingArgsBuilder.() -> Unit) {
        val builder = AzureServersSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AzureServersSetting {
        val builtJavaResource =
            com.pulumi.azurenative.security.AzureServersSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AzureServersSetting(builtJavaResource)
    }
}

/**
 * A vulnerability assessments setting on Azure servers in the defined scope.
 * Azure REST API version: 2023-05-01.
 * ## Example Usage
 * ### Set a server vulnerability assessments setting of the kind settingKind on the subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureServersSetting = new AzureNative.Security.AzureServersSetting("azureServersSetting", new()
 *     {
 *         Kind = "AzureServersSetting",
 *         SelectedProvider = AzureNative.Security.ServerVulnerabilityAssessmentsAzureSettingSelectedProvider.MdeTvm,
 *         SettingKind = "azureServersSetting",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAzureServersSetting(ctx, "azureServersSetting", &security.AzureServersSettingArgs{
 * 			Kind:             pulumi.String("AzureServersSetting"),
 * 			SelectedProvider: pulumi.String(security.ServerVulnerabilityAssessmentsAzureSettingSelectedProviderMdeTvm),
 * 			SettingKind:      pulumi.String("azureServersSetting"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AzureServersSetting;
 * import com.pulumi.azurenative.security.AzureServersSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureServersSetting = new AzureServersSetting("azureServersSetting", AzureServersSettingArgs.builder()
 *             .kind("AzureServersSetting")
 *             .selectedProvider("MdeTvm")
 *             .settingKind("azureServersSetting")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AzureServersSetting azureServersSetting /subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}
 * ```
 */
public class AzureServersSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.security.AzureServersSetting,
) : KotlinCustomResource(javaResource, AzureServersSettingMapper) {
    /**
     * The kind of the server vulnerability assessments setting
     * Expected value is 'AzureServersSetting'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The selected vulnerability assessments provider on Azure servers in the defined scope.
     */
    public val selectedProvider: Output<String>
        get() = javaResource.selectedProvider().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AzureServersSettingMapper : ResourceMapper<AzureServersSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.AzureServersSetting::class == javaResource::class

    override fun map(javaResource: Resource): AzureServersSetting = AzureServersSetting(
        javaResource
            as com.pulumi.azurenative.security.AzureServersSetting,
    )
}

/**
 * @see [AzureServersSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureServersSetting].
 */
public suspend fun azureServersSetting(
    name: String,
    block: suspend AzureServersSettingResourceBuilder.() -> Unit,
): AzureServersSetting {
    val builder = AzureServersSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureServersSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureServersSetting(name: String): AzureServersSetting {
    val builder = AzureServersSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
