@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.MalwareScanningPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.SensitiveDataDiscoveryPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.security.kotlin.outputs.MalwareScanningPropertiesResponse.Companion.toKotlin as malwareScanningPropertiesResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SensitiveDataDiscoveryPropertiesResponse.Companion.toKotlin as sensitiveDataDiscoveryPropertiesResponseToKotlin

/**
 * Builder for [DefenderForStorage].
 */
@PulumiTagMarker
public class DefenderForStorageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefenderForStorageArgs = DefenderForStorageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefenderForStorageArgsBuilder.() -> Unit) {
        val builder = DefenderForStorageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DefenderForStorage {
        val builtJavaResource =
            com.pulumi.azurenative.security.DefenderForStorage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DefenderForStorage(builtJavaResource)
    }
}

/**
 * The Defender for Storage resource.
 * Azure REST API version: 2022-12-01-preview.
 * ## Example Usage
 * ### Creates or updates the Defender for Storage settings on a specified resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defenderForStorage = new AzureNative.Security.DefenderForStorage("defenderForStorage", new()
 *     {
 *         IsEnabled = true,
 *         MalwareScanning = new AzureNative.Security.Inputs.MalwareScanningPropertiesArgs
 *         {
 *             CapGBPerMonth = -1,
 *             IsEnabled = true,
 *             ScanResultsEventGridTopicResourceId = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.EventGrid/topics/sampletopic",
 *         },
 *         OverrideSubscriptionLevelSettings = true,
 *         ResourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount",
 *         SensitiveDataDiscovery = new AzureNative.Security.Inputs.SensitiveDataDiscoveryPropertiesArgs
 *         {
 *             IsEnabled = true,
 *         },
 *         SettingName = "current",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDefenderForStorage(ctx, "defenderForStorage", &security.DefenderForStorageArgs{
 * 			IsEnabled: pulumi.Bool(true),
 * 			MalwareScanning: &security.MalwareScanningPropertiesArgs{
 * 				CapGBPerMonth:                       -1,
 * 				IsEnabled:                           pulumi.Bool(true),
 * 				ScanResultsEventGridTopicResourceId: pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.EventGrid/topics/sampletopic"),
 * 			},
 * 			OverrideSubscriptionLevelSettings: pulumi.Bool(true),
 * 			ResourceId:                        pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount"),
 * 			SensitiveDataDiscovery: &security.SensitiveDataDiscoveryPropertiesArgs{
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			SettingName: pulumi.String("current"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DefenderForStorage;
 * import com.pulumi.azurenative.security.DefenderForStorageArgs;
 * import com.pulumi.azurenative.security.inputs.MalwareScanningPropertiesArgs;
 * import com.pulumi.azurenative.security.inputs.SensitiveDataDiscoveryPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defenderForStorage = new DefenderForStorage("defenderForStorage", DefenderForStorageArgs.builder()
 *             .isEnabled(true)
 *             .malwareScanning(MalwareScanningPropertiesArgs.builder()
 *                 .capGBPerMonth("TODO: GenUnaryOpExpression")
 *                 .isEnabled(true)
 *                 .scanResultsEventGridTopicResourceId("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.EventGrid/topics/sampletopic")
 *                 .build())
 *             .overrideSubscriptionLevelSettings(true)
 *             .resourceId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount")
 *             .sensitiveDataDiscovery(SensitiveDataDiscoveryPropertiesArgs.builder()
 *                 .isEnabled(true)
 *                 .build())
 *             .settingName("current")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:DefenderForStorage current /{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}
 * ```
 */
public class DefenderForStorage internal constructor(
    override val javaResource: com.pulumi.azurenative.security.DefenderForStorage,
) : KotlinCustomResource(javaResource, DefenderForStorageMapper) {
    /**
     * Indicates whether Defender for Storage is enabled on this storage account.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Properties of Malware Scanning.
     */
    public val malwareScanning: Output<MalwareScanningPropertiesResponse>?
        get() = javaResource.malwareScanning().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> malwareScanningPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the settings defined for this storage account should override the settings defined for the subscription.
     */
    public val overrideSubscriptionLevelSettings: Output<Boolean>?
        get() = javaResource.overrideSubscriptionLevelSettings().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Properties of Sensitive Data Discovery.
     */
    public val sensitiveDataDiscovery: Output<SensitiveDataDiscoveryPropertiesResponse>?
        get() = javaResource.sensitiveDataDiscovery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sensitiveDataDiscoveryPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DefenderForStorageMapper : ResourceMapper<DefenderForStorage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.DefenderForStorage::class == javaResource::class

    override fun map(javaResource: Resource): DefenderForStorage = DefenderForStorage(
        javaResource as
            com.pulumi.azurenative.security.DefenderForStorage,
    )
}

/**
 * @see [DefenderForStorage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefenderForStorage].
 */
public suspend fun defenderForStorage(
    name: String,
    block: suspend DefenderForStorageResourceBuilder.() -> Unit,
): DefenderForStorage {
    val builder = DefenderForStorageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefenderForStorage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defenderForStorage(name: String): DefenderForStorage {
    val builder = DefenderForStorageResourceBuilder()
    builder.name(name)
    return builder.build()
}
