@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.DefenderForStorageArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.MalwareScanningPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.MalwareScanningPropertiesArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.SensitiveDataDiscoveryPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.SensitiveDataDiscoveryPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Defender for Storage resource.
 * Azure REST API version: 2022-12-01-preview.
 * ## Example Usage
 * ### Creates or updates the Defender for Storage settings on a specified resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defenderForStorage = new AzureNative.Security.DefenderForStorage("defenderForStorage", new()
 *     {
 *         IsEnabled = true,
 *         MalwareScanning = new AzureNative.Security.Inputs.MalwareScanningPropertiesArgs
 *         {
 *             CapGBPerMonth = -1,
 *             IsEnabled = true,
 *             ScanResultsEventGridTopicResourceId = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.EventGrid/topics/sampletopic",
 *         },
 *         OverrideSubscriptionLevelSettings = true,
 *         ResourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount",
 *         SensitiveDataDiscovery = new AzureNative.Security.Inputs.SensitiveDataDiscoveryPropertiesArgs
 *         {
 *             IsEnabled = true,
 *         },
 *         SettingName = "current",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDefenderForStorage(ctx, "defenderForStorage", &security.DefenderForStorageArgs{
 * 			IsEnabled: pulumi.Bool(true),
 * 			MalwareScanning: &security.MalwareScanningPropertiesArgs{
 * 				CapGBPerMonth:                       -1,
 * 				IsEnabled:                           pulumi.Bool(true),
 * 				ScanResultsEventGridTopicResourceId: pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.EventGrid/topics/sampletopic"),
 * 			},
 * 			OverrideSubscriptionLevelSettings: pulumi.Bool(true),
 * 			ResourceId:                        pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount"),
 * 			SensitiveDataDiscovery: &security.SensitiveDataDiscoveryPropertiesArgs{
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			SettingName: pulumi.String("current"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DefenderForStorage;
 * import com.pulumi.azurenative.security.DefenderForStorageArgs;
 * import com.pulumi.azurenative.security.inputs.MalwareScanningPropertiesArgs;
 * import com.pulumi.azurenative.security.inputs.SensitiveDataDiscoveryPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defenderForStorage = new DefenderForStorage("defenderForStorage", DefenderForStorageArgs.builder()
 *             .isEnabled(true)
 *             .malwareScanning(MalwareScanningPropertiesArgs.builder()
 *                 .capGBPerMonth("TODO: GenUnaryOpExpression")
 *                 .isEnabled(true)
 *                 .scanResultsEventGridTopicResourceId("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.EventGrid/topics/sampletopic")
 *                 .build())
 *             .overrideSubscriptionLevelSettings(true)
 *             .resourceId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount")
 *             .sensitiveDataDiscovery(SensitiveDataDiscoveryPropertiesArgs.builder()
 *                 .isEnabled(true)
 *                 .build())
 *             .settingName("current")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:DefenderForStorage current /{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}
 * ```
 * @property isEnabled Indicates whether Defender for Storage is enabled on this storage account.
 * @property malwareScanning Properties of Malware Scanning.
 * @property overrideSubscriptionLevelSettings Indicates whether the settings defined for this storage account should override the settings defined for the subscription.
 * @property resourceId The identifier of the resource.
 * @property sensitiveDataDiscovery Properties of Sensitive Data Discovery.
 * @property settingName Defender for Storage setting name.
 */
public data class DefenderForStorageArgs(
    public val isEnabled: Output<Boolean>? = null,
    public val malwareScanning: Output<MalwareScanningPropertiesArgs>? = null,
    public val overrideSubscriptionLevelSettings: Output<Boolean>? = null,
    public val resourceId: Output<String>? = null,
    public val sensitiveDataDiscovery: Output<SensitiveDataDiscoveryPropertiesArgs>? = null,
    public val settingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.DefenderForStorageArgs> {
    override fun toJava(): com.pulumi.azurenative.security.DefenderForStorageArgs =
        com.pulumi.azurenative.security.DefenderForStorageArgs.builder()
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .malwareScanning(malwareScanning?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .overrideSubscriptionLevelSettings(
                overrideSubscriptionLevelSettings?.applyValue({ args0 ->
                    args0
                }),
            )
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .sensitiveDataDiscovery(
                sensitiveDataDiscovery?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .settingName(settingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForStorageArgs].
 */
@PulumiTagMarker
public class DefenderForStorageArgsBuilder internal constructor() {
    private var isEnabled: Output<Boolean>? = null

    private var malwareScanning: Output<MalwareScanningPropertiesArgs>? = null

    private var overrideSubscriptionLevelSettings: Output<Boolean>? = null

    private var resourceId: Output<String>? = null

    private var sensitiveDataDiscovery: Output<SensitiveDataDiscoveryPropertiesArgs>? = null

    private var settingName: Output<String>? = null

    /**
     * @param value Indicates whether Defender for Storage is enabled on this storage account.
     */
    @JvmName("ajpcjqmwjqwbcxdo")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Properties of Malware Scanning.
     */
    @JvmName("qqwdqyrkbuqmnbhw")
    public suspend fun malwareScanning(`value`: Output<MalwareScanningPropertiesArgs>) {
        this.malwareScanning = value
    }

    /**
     * @param value Indicates whether the settings defined for this storage account should override the settings defined for the subscription.
     */
    @JvmName("vaxxwwohklhdjbjj")
    public suspend fun overrideSubscriptionLevelSettings(`value`: Output<Boolean>) {
        this.overrideSubscriptionLevelSettings = value
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("spoafpyehsctvmef")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Properties of Sensitive Data Discovery.
     */
    @JvmName("jlrnsuphyxkumgie")
    public suspend fun sensitiveDataDiscovery(`value`: Output<SensitiveDataDiscoveryPropertiesArgs>) {
        this.sensitiveDataDiscovery = value
    }

    /**
     * @param value Defender for Storage setting name.
     */
    @JvmName("ifssdhxsnopodhfg")
    public suspend fun settingName(`value`: Output<String>) {
        this.settingName = value
    }

    /**
     * @param value Indicates whether Defender for Storage is enabled on this storage account.
     */
    @JvmName("grmvhmwwwkvojctx")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Properties of Malware Scanning.
     */
    @JvmName("npqmgsmaqpydddem")
    public suspend fun malwareScanning(`value`: MalwareScanningPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.malwareScanning = mapped
    }

    /**
     * @param argument Properties of Malware Scanning.
     */
    @JvmName("xywqxtshfmcsbuwa")
    public suspend fun malwareScanning(argument: suspend MalwareScanningPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MalwareScanningPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.malwareScanning = mapped
    }

    /**
     * @param value Indicates whether the settings defined for this storage account should override the settings defined for the subscription.
     */
    @JvmName("exxyrewffpvhpqgu")
    public suspend fun overrideSubscriptionLevelSettings(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideSubscriptionLevelSettings = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("erljvmjqctdhqwip")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Properties of Sensitive Data Discovery.
     */
    @JvmName("nejdhpxctfdftqda")
    public suspend fun sensitiveDataDiscovery(`value`: SensitiveDataDiscoveryPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sensitiveDataDiscovery = mapped
    }

    /**
     * @param argument Properties of Sensitive Data Discovery.
     */
    @JvmName("xmwiptfskwrxtbsh")
    public suspend fun sensitiveDataDiscovery(argument: suspend SensitiveDataDiscoveryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SensitiveDataDiscoveryPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sensitiveDataDiscovery = mapped
    }

    /**
     * @param value Defender for Storage setting name.
     */
    @JvmName("gefcqnugsutexplr")
    public suspend fun settingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingName = mapped
    }

    internal fun build(): DefenderForStorageArgs = DefenderForStorageArgs(
        isEnabled = isEnabled,
        malwareScanning = malwareScanning,
        overrideSubscriptionLevelSettings = overrideSubscriptionLevelSettings,
        resourceId = resourceId,
        sensitiveDataDiscovery = sensitiveDataDiscovery,
        settingName = settingName,
    )
}
