@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.DevOpsPolicyAssignmentPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.security.kotlin.outputs.DevOpsPolicyAssignmentPropertiesResponse.Companion.toKotlin as devOpsPolicyAssignmentPropertiesResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DevOpsPolicyAssignment].
 */
@PulumiTagMarker
public class DevOpsPolicyAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevOpsPolicyAssignmentArgs = DevOpsPolicyAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevOpsPolicyAssignmentArgsBuilder.() -> Unit) {
        val builder = DevOpsPolicyAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DevOpsPolicyAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.security.DevOpsPolicyAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DevOpsPolicyAssignment(builtJavaResource)
    }
}

/**
 * DevOps Policy assignment resource.
 * Azure REST API version: 2024-05-15-preview.
 * ## Example Usage
 * ### CreateOrUpdate_DevOpsPolicyAssignments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devOpsPolicyAssignment = new AzureNative.Security.DevOpsPolicyAssignment("devOpsPolicyAssignment", new()
 *     {
 *         PolicyAssignmentId = "5ec87f43-62d8-437b-8f46-4c8d4032cf6d",
 *         Properties = new AzureNative.Security.Inputs.DevOpsPolicyAssignmentPropertiesArgs
 *         {
 *             DescendantBehavior = AzureNative.Security.DescendantBehavior.Override,
 *             Policy = new AzureNative.Security.Inputs.DevOpsPolicyDescriptorArgs
 *             {
 *                 PolicyId = "00000000-0000-0000-0000-000000000000",
 *                 PolicyName = "myDevOpsPolicy",
 *                 PolicyType = AzureNative.Security.DevOpsPolicyType.Pipeline,
 *                 PolicyVersion = "1.0",
 *             },
 *             ResourceId = "/subscriptions/0806e1cd-cfda-4ff8-b99c-2b0af42cffd3/resourcegroups/myRg/providers/Microsoft.Security/securityConnectors/mySecurityConnectorName/devops/default/azureDevOpsOrgs/Contoso",
 *         },
 *         ResourceGroupName = "myRg",
 *         SecurityConnectorName = "mySecurityConnectorName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDevOpsPolicyAssignment(ctx, "devOpsPolicyAssignment", &security.DevOpsPolicyAssignmentArgs{
 * 			PolicyAssignmentId: pulumi.String("5ec87f43-62d8-437b-8f46-4c8d4032cf6d"),
 * 			Properties: &security.DevOpsPolicyAssignmentPropertiesArgs{
 * 				DescendantBehavior: pulumi.String(security.DescendantBehaviorOverride),
 * 				Policy: &security.DevOpsPolicyDescriptorArgs{
 * 					PolicyId:      pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 					PolicyName:    pulumi.String("myDevOpsPolicy"),
 * 					PolicyType:    pulumi.String(security.DevOpsPolicyTypePipeline),
 * 					PolicyVersion: pulumi.String("1.0"),
 * 				},
 * 				ResourceId: pulumi.String("/subscriptions/0806e1cd-cfda-4ff8-b99c-2b0af42cffd3/resourcegroups/myRg/providers/Microsoft.Security/securityConnectors/mySecurityConnectorName/devops/default/azureDevOpsOrgs/Contoso"),
 * 			},
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			SecurityConnectorName: pulumi.String("mySecurityConnectorName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DevOpsPolicyAssignment;
 * import com.pulumi.azurenative.security.DevOpsPolicyAssignmentArgs;
 * import com.pulumi.azurenative.security.inputs.DevOpsPolicyAssignmentPropertiesArgs;
 * import com.pulumi.azurenative.security.inputs.DevOpsPolicyDescriptorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devOpsPolicyAssignment = new DevOpsPolicyAssignment("devOpsPolicyAssignment", DevOpsPolicyAssignmentArgs.builder()
 *             .policyAssignmentId("5ec87f43-62d8-437b-8f46-4c8d4032cf6d")
 *             .properties(DevOpsPolicyAssignmentPropertiesArgs.builder()
 *                 .descendantBehavior("Override")
 *                 .policy(DevOpsPolicyDescriptorArgs.builder()
 *                     .policyId("00000000-0000-0000-0000-000000000000")
 *                     .policyName("myDevOpsPolicy")
 *                     .policyType("Pipeline")
 *                     .policyVersion("1.0")
 *                     .build())
 *                 .resourceId("/subscriptions/0806e1cd-cfda-4ff8-b99c-2b0af42cffd3/resourcegroups/myRg/providers/Microsoft.Security/securityConnectors/mySecurityConnectorName/devops/default/azureDevOpsOrgs/Contoso")
 *                 .build())
 *             .resourceGroupName("myRg")
 *             .securityConnectorName("mySecurityConnectorName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:DevOpsPolicyAssignment 5ec87f43-62d8-437b-8f46-4c8d4032cf6d /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/policyAssignments/{policyAssignmentId}
 * ```
 */
public class DevOpsPolicyAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.security.DevOpsPolicyAssignment,
) : KotlinCustomResource(javaResource, DevOpsPolicyAssignmentMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the DevOps policy assignment resource.
     */
    public val properties: Output<DevOpsPolicyAssignmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                devOpsPolicyAssignmentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DevOpsPolicyAssignmentMapper : ResourceMapper<DevOpsPolicyAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.DevOpsPolicyAssignment::class == javaResource::class

    override fun map(javaResource: Resource): DevOpsPolicyAssignment =
        DevOpsPolicyAssignment(javaResource as com.pulumi.azurenative.security.DevOpsPolicyAssignment)
}

/**
 * @see [DevOpsPolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevOpsPolicyAssignment].
 */
public suspend fun devOpsPolicyAssignment(
    name: String,
    block: suspend DevOpsPolicyAssignmentResourceBuilder.() -> Unit,
): DevOpsPolicyAssignment {
    val builder = DevOpsPolicyAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevOpsPolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devOpsPolicyAssignment(name: String): DevOpsPolicyAssignment {
    val builder = DevOpsPolicyAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
