@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.DevOpsPolicyAssignmentArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.DevOpsPolicyAssignmentPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.DevOpsPolicyAssignmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DevOps Policy assignment resource.
 * Azure REST API version: 2024-05-15-preview.
 * ## Example Usage
 * ### CreateOrUpdate_DevOpsPolicyAssignments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devOpsPolicyAssignment = new AzureNative.Security.DevOpsPolicyAssignment("devOpsPolicyAssignment", new()
 *     {
 *         PolicyAssignmentId = "5ec87f43-62d8-437b-8f46-4c8d4032cf6d",
 *         Properties = new AzureNative.Security.Inputs.DevOpsPolicyAssignmentPropertiesArgs
 *         {
 *             DescendantBehavior = AzureNative.Security.DescendantBehavior.Override,
 *             Policy = new AzureNative.Security.Inputs.DevOpsPolicyDescriptorArgs
 *             {
 *                 PolicyId = "00000000-0000-0000-0000-000000000000",
 *                 PolicyName = "myDevOpsPolicy",
 *                 PolicyType = AzureNative.Security.DevOpsPolicyType.Pipeline,
 *                 PolicyVersion = "1.0",
 *             },
 *             ResourceId = "/subscriptions/0806e1cd-cfda-4ff8-b99c-2b0af42cffd3/resourcegroups/myRg/providers/Microsoft.Security/securityConnectors/mySecurityConnectorName/devops/default/azureDevOpsOrgs/Contoso",
 *         },
 *         ResourceGroupName = "myRg",
 *         SecurityConnectorName = "mySecurityConnectorName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDevOpsPolicyAssignment(ctx, "devOpsPolicyAssignment", &security.DevOpsPolicyAssignmentArgs{
 * 			PolicyAssignmentId: pulumi.String("5ec87f43-62d8-437b-8f46-4c8d4032cf6d"),
 * 			Properties: &security.DevOpsPolicyAssignmentPropertiesArgs{
 * 				DescendantBehavior: pulumi.String(security.DescendantBehaviorOverride),
 * 				Policy: &security.DevOpsPolicyDescriptorArgs{
 * 					PolicyId:      pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 					PolicyName:    pulumi.String("myDevOpsPolicy"),
 * 					PolicyType:    pulumi.String(security.DevOpsPolicyTypePipeline),
 * 					PolicyVersion: pulumi.String("1.0"),
 * 				},
 * 				ResourceId: pulumi.String("/subscriptions/0806e1cd-cfda-4ff8-b99c-2b0af42cffd3/resourcegroups/myRg/providers/Microsoft.Security/securityConnectors/mySecurityConnectorName/devops/default/azureDevOpsOrgs/Contoso"),
 * 			},
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			SecurityConnectorName: pulumi.String("mySecurityConnectorName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DevOpsPolicyAssignment;
 * import com.pulumi.azurenative.security.DevOpsPolicyAssignmentArgs;
 * import com.pulumi.azurenative.security.inputs.DevOpsPolicyAssignmentPropertiesArgs;
 * import com.pulumi.azurenative.security.inputs.DevOpsPolicyDescriptorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devOpsPolicyAssignment = new DevOpsPolicyAssignment("devOpsPolicyAssignment", DevOpsPolicyAssignmentArgs.builder()
 *             .policyAssignmentId("5ec87f43-62d8-437b-8f46-4c8d4032cf6d")
 *             .properties(DevOpsPolicyAssignmentPropertiesArgs.builder()
 *                 .descendantBehavior("Override")
 *                 .policy(DevOpsPolicyDescriptorArgs.builder()
 *                     .policyId("00000000-0000-0000-0000-000000000000")
 *                     .policyName("myDevOpsPolicy")
 *                     .policyType("Pipeline")
 *                     .policyVersion("1.0")
 *                     .build())
 *                 .resourceId("/subscriptions/0806e1cd-cfda-4ff8-b99c-2b0af42cffd3/resourcegroups/myRg/providers/Microsoft.Security/securityConnectors/mySecurityConnectorName/devops/default/azureDevOpsOrgs/Contoso")
 *                 .build())
 *             .resourceGroupName("myRg")
 *             .securityConnectorName("mySecurityConnectorName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:DevOpsPolicyAssignment 5ec87f43-62d8-437b-8f46-4c8d4032cf6d /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/policyAssignments/{policyAssignmentId}
 * ```
 * @property policyAssignmentId The policy assignment Id.
 * @property properties Properties of the DevOps policy assignment resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 */
public data class DevOpsPolicyAssignmentArgs(
    public val policyAssignmentId: Output<String>? = null,
    public val properties: Output<DevOpsPolicyAssignmentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityConnectorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.DevOpsPolicyAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.security.DevOpsPolicyAssignmentArgs =
        com.pulumi.azurenative.security.DevOpsPolicyAssignmentArgs.builder()
            .policyAssignmentId(policyAssignmentId?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevOpsPolicyAssignmentArgs].
 */
@PulumiTagMarker
public class DevOpsPolicyAssignmentArgsBuilder internal constructor() {
    private var policyAssignmentId: Output<String>? = null

    private var properties: Output<DevOpsPolicyAssignmentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityConnectorName: Output<String>? = null

    /**
     * @param value The policy assignment Id.
     */
    @JvmName("tqqifbfsuorhonmh")
    public suspend fun policyAssignmentId(`value`: Output<String>) {
        this.policyAssignmentId = value
    }

    /**
     * @param value Properties of the DevOps policy assignment resource.
     */
    @JvmName("drghfrosnxdhvlgq")
    public suspend fun properties(`value`: Output<DevOpsPolicyAssignmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("awmgoirncncgadym")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("greaummbmyvsdbxn")
    public suspend fun securityConnectorName(`value`: Output<String>) {
        this.securityConnectorName = value
    }

    /**
     * @param value The policy assignment Id.
     */
    @JvmName("obbsotiedubfcqca")
    public suspend fun policyAssignmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyAssignmentId = mapped
    }

    /**
     * @param value Properties of the DevOps policy assignment resource.
     */
    @JvmName("pwjptgjqjwvbiman")
    public suspend fun properties(`value`: DevOpsPolicyAssignmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the DevOps policy assignment resource.
     */
    @JvmName("uqkbqqpeuperyqju")
    public suspend fun properties(argument: suspend DevOpsPolicyAssignmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DevOpsPolicyAssignmentPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mgsgqvqpnrcbbouh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("hfppjefokuomnowe")
    public suspend fun securityConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConnectorName = mapped
    }

    internal fun build(): DevOpsPolicyAssignmentArgs = DevOpsPolicyAssignmentArgs(
        policyAssignmentId = policyAssignmentId,
        properties = properties,
        resourceGroupName = resourceGroupName,
        securityConnectorName = securityConnectorName,
    )
}
