@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.DeviceSecurityGroupArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.AllowlistCustomAlertRuleArgs
import com.pulumi.azurenative.security.kotlin.inputs.AllowlistCustomAlertRuleArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.DenylistCustomAlertRuleArgs
import com.pulumi.azurenative.security.kotlin.inputs.DenylistCustomAlertRuleArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.ThresholdCustomAlertRuleArgs
import com.pulumi.azurenative.security.kotlin.inputs.ThresholdCustomAlertRuleArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.TimeWindowCustomAlertRuleArgs
import com.pulumi.azurenative.security.kotlin.inputs.TimeWindowCustomAlertRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The device security group resource
 * Azure REST API version: 2019-08-01. Prior API version in Azure Native 1.x: 2019-08-01.
 * ## Example Usage
 * ### Create or update a device security group for the specified IoT hub resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deviceSecurityGroup = new AzureNative.Security.DeviceSecurityGroup("deviceSecurityGroup", new()
 *     {
 *         DeviceSecurityGroupName = "samplesecuritygroup",
 *         ResourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Devices/iotHubs/sampleiothub",
 *         TimeWindowRules = new[]
 *         {
 *             null,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDeviceSecurityGroup(ctx, "deviceSecurityGroup", &security.DeviceSecurityGroupArgs{
 * 			DeviceSecurityGroupName: pulumi.String("samplesecuritygroup"),
 * 			ResourceId:              pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Devices/iotHubs/sampleiothub"),
 * 			TimeWindowRules: security.TimeWindowCustomAlertRuleArray{
 * 				nil,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DeviceSecurityGroup;
 * import com.pulumi.azurenative.security.DeviceSecurityGroupArgs;
 * import com.pulumi.azurenative.security.inputs.TimeWindowCustomAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deviceSecurityGroup = new DeviceSecurityGroup("deviceSecurityGroup", DeviceSecurityGroupArgs.builder()
 *             .deviceSecurityGroupName("samplesecuritygroup")
 *             .resourceId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Devices/iotHubs/sampleiothub")
 *             .timeWindowRules()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:DeviceSecurityGroup samplesecuritygroup /{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}
 * ```
 * @property allowlistRules The allow-list custom alert rules.
 * @property denylistRules The deny-list custom alert rules.
 * @property deviceSecurityGroupName The name of the device security group. Note that the name of the device security group is case insensitive.
 * @property resourceId The identifier of the resource.
 * @property thresholdRules The list of custom alert threshold rules.
 * @property timeWindowRules The list of custom alert time-window rules.
 */
public data class DeviceSecurityGroupArgs(
    public val allowlistRules: Output<List<AllowlistCustomAlertRuleArgs>>? = null,
    public val denylistRules: Output<List<DenylistCustomAlertRuleArgs>>? = null,
    public val deviceSecurityGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val thresholdRules: Output<List<ThresholdCustomAlertRuleArgs>>? = null,
    public val timeWindowRules: Output<List<TimeWindowCustomAlertRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.DeviceSecurityGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.security.DeviceSecurityGroupArgs =
        com.pulumi.azurenative.security.DeviceSecurityGroupArgs.builder()
            .allowlistRules(
                allowlistRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .denylistRules(
                denylistRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deviceSecurityGroupName(deviceSecurityGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .thresholdRules(
                thresholdRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeWindowRules(
                timeWindowRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeviceSecurityGroupArgs].
 */
@PulumiTagMarker
public class DeviceSecurityGroupArgsBuilder internal constructor() {
    private var allowlistRules: Output<List<AllowlistCustomAlertRuleArgs>>? = null

    private var denylistRules: Output<List<DenylistCustomAlertRuleArgs>>? = null

    private var deviceSecurityGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var thresholdRules: Output<List<ThresholdCustomAlertRuleArgs>>? = null

    private var timeWindowRules: Output<List<TimeWindowCustomAlertRuleArgs>>? = null

    /**
     * @param value The allow-list custom alert rules.
     */
    @JvmName("cqdqnogqelrppcmc")
    public suspend fun allowlistRules(`value`: Output<List<AllowlistCustomAlertRuleArgs>>) {
        this.allowlistRules = value
    }

    @JvmName("bewdqqppxrmmqfwh")
    public suspend fun allowlistRules(vararg values: Output<AllowlistCustomAlertRuleArgs>) {
        this.allowlistRules = Output.all(values.asList())
    }

    /**
     * @param values The allow-list custom alert rules.
     */
    @JvmName("pmvahxgccpmvmyic")
    public suspend fun allowlistRules(values: List<Output<AllowlistCustomAlertRuleArgs>>) {
        this.allowlistRules = Output.all(values)
    }

    /**
     * @param value The deny-list custom alert rules.
     */
    @JvmName("inqolhxfxvfdpmrh")
    public suspend fun denylistRules(`value`: Output<List<DenylistCustomAlertRuleArgs>>) {
        this.denylistRules = value
    }

    @JvmName("cupyicuipsrlcntv")
    public suspend fun denylistRules(vararg values: Output<DenylistCustomAlertRuleArgs>) {
        this.denylistRules = Output.all(values.asList())
    }

    /**
     * @param values The deny-list custom alert rules.
     */
    @JvmName("glsmhcmklxoynwcj")
    public suspend fun denylistRules(values: List<Output<DenylistCustomAlertRuleArgs>>) {
        this.denylistRules = Output.all(values)
    }

    /**
     * @param value The name of the device security group. Note that the name of the device security group is case insensitive.
     */
    @JvmName("pwlkwerkcyhcqlun")
    public suspend fun deviceSecurityGroupName(`value`: Output<String>) {
        this.deviceSecurityGroupName = value
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("uiucjejgrpmwecup")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The list of custom alert threshold rules.
     */
    @JvmName("ilcrgakcjfpiaikt")
    public suspend fun thresholdRules(`value`: Output<List<ThresholdCustomAlertRuleArgs>>) {
        this.thresholdRules = value
    }

    @JvmName("tqbhxgufshkjbbja")
    public suspend fun thresholdRules(vararg values: Output<ThresholdCustomAlertRuleArgs>) {
        this.thresholdRules = Output.all(values.asList())
    }

    /**
     * @param values The list of custom alert threshold rules.
     */
    @JvmName("xjrgubowkyphvujt")
    public suspend fun thresholdRules(values: List<Output<ThresholdCustomAlertRuleArgs>>) {
        this.thresholdRules = Output.all(values)
    }

    /**
     * @param value The list of custom alert time-window rules.
     */
    @JvmName("jjtewtoatxbpaklf")
    public suspend fun timeWindowRules(`value`: Output<List<TimeWindowCustomAlertRuleArgs>>) {
        this.timeWindowRules = value
    }

    @JvmName("fnovyuctueriudgk")
    public suspend fun timeWindowRules(vararg values: Output<TimeWindowCustomAlertRuleArgs>) {
        this.timeWindowRules = Output.all(values.asList())
    }

    /**
     * @param values The list of custom alert time-window rules.
     */
    @JvmName("sucfoxxnwiatgosk")
    public suspend fun timeWindowRules(values: List<Output<TimeWindowCustomAlertRuleArgs>>) {
        this.timeWindowRules = Output.all(values)
    }

    /**
     * @param value The allow-list custom alert rules.
     */
    @JvmName("wimkmuypgsukxrbr")
    public suspend fun allowlistRules(`value`: List<AllowlistCustomAlertRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowlistRules = mapped
    }

    /**
     * @param argument The allow-list custom alert rules.
     */
    @JvmName("eksjlstshjaquerk")
    public suspend fun allowlistRules(argument: List<suspend AllowlistCustomAlertRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AllowlistCustomAlertRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allowlistRules = mapped
    }

    /**
     * @param argument The allow-list custom alert rules.
     */
    @JvmName("edktjxgoevbutift")
    public suspend fun allowlistRules(vararg argument: suspend AllowlistCustomAlertRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AllowlistCustomAlertRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allowlistRules = mapped
    }

    /**
     * @param argument The allow-list custom alert rules.
     */
    @JvmName("nismywatipupicda")
    public suspend fun allowlistRules(argument: suspend AllowlistCustomAlertRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AllowlistCustomAlertRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.allowlistRules = mapped
    }

    /**
     * @param values The allow-list custom alert rules.
     */
    @JvmName("enjphkubcnvhpupv")
    public suspend fun allowlistRules(vararg values: AllowlistCustomAlertRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowlistRules = mapped
    }

    /**
     * @param value The deny-list custom alert rules.
     */
    @JvmName("mynpdaauklubwciq")
    public suspend fun denylistRules(`value`: List<DenylistCustomAlertRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.denylistRules = mapped
    }

    /**
     * @param argument The deny-list custom alert rules.
     */
    @JvmName("hbyvkxhbsxurphbt")
    public suspend fun denylistRules(argument: List<suspend DenylistCustomAlertRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DenylistCustomAlertRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.denylistRules = mapped
    }

    /**
     * @param argument The deny-list custom alert rules.
     */
    @JvmName("rbkkfppofxkdlomy")
    public suspend fun denylistRules(vararg argument: suspend DenylistCustomAlertRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DenylistCustomAlertRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.denylistRules = mapped
    }

    /**
     * @param argument The deny-list custom alert rules.
     */
    @JvmName("jwyeqiswcnnyseny")
    public suspend fun denylistRules(argument: suspend DenylistCustomAlertRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DenylistCustomAlertRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.denylistRules = mapped
    }

    /**
     * @param values The deny-list custom alert rules.
     */
    @JvmName("akpcrekcpeyhdlje")
    public suspend fun denylistRules(vararg values: DenylistCustomAlertRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.denylistRules = mapped
    }

    /**
     * @param value The name of the device security group. Note that the name of the device security group is case insensitive.
     */
    @JvmName("yncdlvmumtkcgihq")
    public suspend fun deviceSecurityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceSecurityGroupName = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("mhouxymdisnnmdvc")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The list of custom alert threshold rules.
     */
    @JvmName("eeusnesindlnjrpd")
    public suspend fun thresholdRules(`value`: List<ThresholdCustomAlertRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdRules = mapped
    }

    /**
     * @param argument The list of custom alert threshold rules.
     */
    @JvmName("cnwodpnuigdmelmt")
    public suspend fun thresholdRules(argument: List<suspend ThresholdCustomAlertRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThresholdCustomAlertRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.thresholdRules = mapped
    }

    /**
     * @param argument The list of custom alert threshold rules.
     */
    @JvmName("gsteqanqnqgauymg")
    public suspend fun thresholdRules(vararg argument: suspend ThresholdCustomAlertRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ThresholdCustomAlertRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.thresholdRules = mapped
    }

    /**
     * @param argument The list of custom alert threshold rules.
     */
    @JvmName("cgovodymdqiqodeo")
    public suspend fun thresholdRules(argument: suspend ThresholdCustomAlertRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ThresholdCustomAlertRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.thresholdRules = mapped
    }

    /**
     * @param values The list of custom alert threshold rules.
     */
    @JvmName("xeniqnxwwqvmsndl")
    public suspend fun thresholdRules(vararg values: ThresholdCustomAlertRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdRules = mapped
    }

    /**
     * @param value The list of custom alert time-window rules.
     */
    @JvmName("wikyeltficfnldat")
    public suspend fun timeWindowRules(`value`: List<TimeWindowCustomAlertRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeWindowRules = mapped
    }

    /**
     * @param argument The list of custom alert time-window rules.
     */
    @JvmName("yfelbxylsuxxnxmq")
    public suspend fun timeWindowRules(argument: List<suspend TimeWindowCustomAlertRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TimeWindowCustomAlertRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timeWindowRules = mapped
    }

    /**
     * @param argument The list of custom alert time-window rules.
     */
    @JvmName("nlkglfnuopbcmfjl")
    public suspend fun timeWindowRules(vararg argument: suspend TimeWindowCustomAlertRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TimeWindowCustomAlertRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timeWindowRules = mapped
    }

    /**
     * @param argument The list of custom alert time-window rules.
     */
    @JvmName("hmarbahpbukdvctr")
    public suspend fun timeWindowRules(argument: suspend TimeWindowCustomAlertRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TimeWindowCustomAlertRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.timeWindowRules = mapped
    }

    /**
     * @param values The list of custom alert time-window rules.
     */
    @JvmName("hglxrgvwthywensw")
    public suspend fun timeWindowRules(vararg values: TimeWindowCustomAlertRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeWindowRules = mapped
    }

    internal fun build(): DeviceSecurityGroupArgs = DeviceSecurityGroupArgs(
        allowlistRules = allowlistRules,
        denylistRules = denylistRules,
        deviceSecurityGroupName = deviceSecurityGroupName,
        resourceId = resourceId,
        thresholdRules = thresholdRules,
        timeWindowRules = timeWindowRules,
    )
}
