@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.GovernanceAssignmentArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.GovernanceAssignmentAdditionalDataArgs
import com.pulumi.azurenative.security.kotlin.inputs.GovernanceAssignmentAdditionalDataArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GovernanceEmailNotificationArgs
import com.pulumi.azurenative.security.kotlin.inputs.GovernanceEmailNotificationArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.RemediationEtaArgs
import com.pulumi.azurenative.security.kotlin.inputs.RemediationEtaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Governance assignment over a given scope
 * Azure REST API version: 2022-01-01-preview.
 * ## Example Usage
 * ### Create Governance assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var governanceAssignment = new AzureNative.Security.GovernanceAssignment("governanceAssignment", new()
 *     {
 *         AdditionalData = new AzureNative.Security.Inputs.GovernanceAssignmentAdditionalDataArgs
 *         {
 *             TicketLink = "https://snow.com",
 *             TicketNumber = 123123,
 *             TicketStatus = "Active",
 *         },
 *         AssessmentName = "6b9421dd-5555-2251-9b3d-2be58e2f82cd",
 *         AssignmentKey = "6634ff9f-127b-4bf2-8e6e-b1737f5e789c",
 *         GovernanceEmailNotification = new AzureNative.Security.Inputs.GovernanceEmailNotificationArgs
 *         {
 *             DisableManagerEmailNotification = false,
 *             DisableOwnerEmailNotification = false,
 *         },
 *         IsGracePeriod = true,
 *         Owner = "user@contoso.com",
 *         RemediationDueDate = "2022-01-07T13:00:00.0000000Z",
 *         RemediationEta = new AzureNative.Security.Inputs.RemediationEtaArgs
 *         {
 *             Eta = "2022-01-08T13:00:00.0000000Z",
 *             Justification = "Justification of ETA",
 *         },
 *         Scope = "subscriptions/c32e05d9-7207-4e22-bdf4-4f7d9c72e5fd/resourceGroups/compute_servers/providers/Microsoft.Compute/virtualMachines/win2012",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewGovernanceAssignment(ctx, "governanceAssignment", &security.GovernanceAssignmentArgs{
 * 			AdditionalData: &security.GovernanceAssignmentAdditionalDataArgs{
 * 				TicketLink:   pulumi.String("https://snow.com"),
 * 				TicketNumber: pulumi.Int(123123),
 * 				TicketStatus: pulumi.String("Active"),
 * 			},
 * 			AssessmentName: pulumi.String("6b9421dd-5555-2251-9b3d-2be58e2f82cd"),
 * 			AssignmentKey:  pulumi.String("6634ff9f-127b-4bf2-8e6e-b1737f5e789c"),
 * 			GovernanceEmailNotification: &security.GovernanceEmailNotificationArgs{
 * 				DisableManagerEmailNotification: pulumi.Bool(false),
 * 				DisableOwnerEmailNotification:   pulumi.Bool(false),
 * 			},
 * 			IsGracePeriod:      pulumi.Bool(true),
 * 			Owner:              pulumi.String("user@contoso.com"),
 * 			RemediationDueDate: pulumi.String("2022-01-07T13:00:00.0000000Z"),
 * 			RemediationEta: &security.RemediationEtaArgs{
 * 				Eta:           pulumi.String("2022-01-08T13:00:00.0000000Z"),
 * 				Justification: pulumi.String("Justification of ETA"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/c32e05d9-7207-4e22-bdf4-4f7d9c72e5fd/resourceGroups/compute_servers/providers/Microsoft.Compute/virtualMachines/win2012"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.GovernanceAssignment;
 * import com.pulumi.azurenative.security.GovernanceAssignmentArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceAssignmentAdditionalDataArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceEmailNotificationArgs;
 * import com.pulumi.azurenative.security.inputs.RemediationEtaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var governanceAssignment = new GovernanceAssignment("governanceAssignment", GovernanceAssignmentArgs.builder()
 *             .additionalData(GovernanceAssignmentAdditionalDataArgs.builder()
 *                 .ticketLink("https://snow.com")
 *                 .ticketNumber(123123)
 *                 .ticketStatus("Active")
 *                 .build())
 *             .assessmentName("6b9421dd-5555-2251-9b3d-2be58e2f82cd")
 *             .assignmentKey("6634ff9f-127b-4bf2-8e6e-b1737f5e789c")
 *             .governanceEmailNotification(GovernanceEmailNotificationArgs.builder()
 *                 .disableManagerEmailNotification(false)
 *                 .disableOwnerEmailNotification(false)
 *                 .build())
 *             .isGracePeriod(true)
 *             .owner("user@contoso.com")
 *             .remediationDueDate("2022-01-07T13:00:00.0000000Z")
 *             .remediationEta(RemediationEtaArgs.builder()
 *                 .eta("2022-01-08T13:00:00.0000000Z")
 *                 .justification("Justification of ETA")
 *                 .build())
 *             .scope("subscriptions/c32e05d9-7207-4e22-bdf4-4f7d9c72e5fd/resourceGroups/compute_servers/providers/Microsoft.Compute/virtualMachines/win2012")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:GovernanceAssignment 6634ff9f-127b-4bf2-8e6e-b1737f5e789c /{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}
 * ```
 * @property additionalData The additional data for the governance assignment - e.g. links to ticket (optional), see example
 * @property assessmentName The Assessment Key - A unique key for the assessment type
 * @property assignmentKey The governance assignment key - the assessment key of the required governance assignment
 * @property governanceEmailNotification The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
 * @property isGracePeriod Defines whether there is a grace period on the governance assignment
 * @property owner The Owner for the governance assignment - e.g. user@contoso.com - see example
 * @property remediationDueDate The remediation due-date - after this date Secure Score will be affected (in case of  active grace-period)
 * @property remediationEta The ETA (estimated time of arrival) for remediation (optional), see example
 * @property scope The scope of the Governance assignments. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
 */
public data class GovernanceAssignmentArgs(
    public val additionalData: Output<GovernanceAssignmentAdditionalDataArgs>? = null,
    public val assessmentName: Output<String>? = null,
    public val assignmentKey: Output<String>? = null,
    public val governanceEmailNotification: Output<GovernanceEmailNotificationArgs>? = null,
    public val isGracePeriod: Output<Boolean>? = null,
    public val owner: Output<String>? = null,
    public val remediationDueDate: Output<String>? = null,
    public val remediationEta: Output<RemediationEtaArgs>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.GovernanceAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.security.GovernanceAssignmentArgs =
        com.pulumi.azurenative.security.GovernanceAssignmentArgs.builder()
            .additionalData(additionalData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .assignmentKey(assignmentKey?.applyValue({ args0 -> args0 }))
            .governanceEmailNotification(
                governanceEmailNotification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isGracePeriod(isGracePeriod?.applyValue({ args0 -> args0 }))
            .owner(owner?.applyValue({ args0 -> args0 }))
            .remediationDueDate(remediationDueDate?.applyValue({ args0 -> args0 }))
            .remediationEta(remediationEta?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GovernanceAssignmentArgs].
 */
@PulumiTagMarker
public class GovernanceAssignmentArgsBuilder internal constructor() {
    private var additionalData: Output<GovernanceAssignmentAdditionalDataArgs>? = null

    private var assessmentName: Output<String>? = null

    private var assignmentKey: Output<String>? = null

    private var governanceEmailNotification: Output<GovernanceEmailNotificationArgs>? = null

    private var isGracePeriod: Output<Boolean>? = null

    private var owner: Output<String>? = null

    private var remediationDueDate: Output<String>? = null

    private var remediationEta: Output<RemediationEtaArgs>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The additional data for the governance assignment - e.g. links to ticket (optional), see example
     */
    @JvmName("muyyplrluksiphlg")
    public suspend fun additionalData(`value`: Output<GovernanceAssignmentAdditionalDataArgs>) {
        this.additionalData = value
    }

    /**
     * @param value The Assessment Key - A unique key for the assessment type
     */
    @JvmName("jilgwdadqrgqmobi")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value The governance assignment key - the assessment key of the required governance assignment
     */
    @JvmName("sqdmoibaojgsqufe")
    public suspend fun assignmentKey(`value`: Output<String>) {
        this.assignmentKey = value
    }

    /**
     * @param value The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
     */
    @JvmName("sgindironyysxmdu")
    public suspend fun governanceEmailNotification(`value`: Output<GovernanceEmailNotificationArgs>) {
        this.governanceEmailNotification = value
    }

    /**
     * @param value Defines whether there is a grace period on the governance assignment
     */
    @JvmName("prwurstsuiepgtnd")
    public suspend fun isGracePeriod(`value`: Output<Boolean>) {
        this.isGracePeriod = value
    }

    /**
     * @param value The Owner for the governance assignment - e.g. user@contoso.com - see example
     */
    @JvmName("hutqlpiilkliuyoy")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value The remediation due-date - after this date Secure Score will be affected (in case of  active grace-period)
     */
    @JvmName("vieysnratruujcmi")
    public suspend fun remediationDueDate(`value`: Output<String>) {
        this.remediationDueDate = value
    }

    /**
     * @param value The ETA (estimated time of arrival) for remediation (optional), see example
     */
    @JvmName("uxrsproteobnleqj")
    public suspend fun remediationEta(`value`: Output<RemediationEtaArgs>) {
        this.remediationEta = value
    }

    /**
     * @param value The scope of the Governance assignments. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
     */
    @JvmName("wgtdyfahrdtxtovk")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The additional data for the governance assignment - e.g. links to ticket (optional), see example
     */
    @JvmName("gdfburvkasmxntec")
    public suspend fun additionalData(`value`: GovernanceAssignmentAdditionalDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalData = mapped
    }

    /**
     * @param argument The additional data for the governance assignment - e.g. links to ticket (optional), see example
     */
    @JvmName("xfsfgsbbhibfsirk")
    public suspend fun additionalData(argument: suspend GovernanceAssignmentAdditionalDataArgsBuilder.() -> Unit) {
        val toBeMapped = GovernanceAssignmentAdditionalDataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.additionalData = mapped
    }

    /**
     * @param value The Assessment Key - A unique key for the assessment type
     */
    @JvmName("foumkbtwxkeerscr")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value The governance assignment key - the assessment key of the required governance assignment
     */
    @JvmName("hkbhfnqtoocebqqs")
    public suspend fun assignmentKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentKey = mapped
    }

    /**
     * @param value The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
     */
    @JvmName("jkiklgegtmbcaxcg")
    public suspend fun governanceEmailNotification(`value`: GovernanceEmailNotificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.governanceEmailNotification = mapped
    }

    /**
     * @param argument The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
     */
    @JvmName("bqhrptgnpyctuujy")
    public suspend fun governanceEmailNotification(argument: suspend GovernanceEmailNotificationArgsBuilder.() -> Unit) {
        val toBeMapped = GovernanceEmailNotificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.governanceEmailNotification = mapped
    }

    /**
     * @param value Defines whether there is a grace period on the governance assignment
     */
    @JvmName("whgemtrevteuxqgy")
    public suspend fun isGracePeriod(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isGracePeriod = mapped
    }

    /**
     * @param value The Owner for the governance assignment - e.g. user@contoso.com - see example
     */
    @JvmName("fgnhlfwqsqvhpkla")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value The remediation due-date - after this date Secure Score will be affected (in case of  active grace-period)
     */
    @JvmName("qcseupgbvdnjkerr")
    public suspend fun remediationDueDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationDueDate = mapped
    }

    /**
     * @param value The ETA (estimated time of arrival) for remediation (optional), see example
     */
    @JvmName("cfbiahtcxwpskqpx")
    public suspend fun remediationEta(`value`: RemediationEtaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationEta = mapped
    }

    /**
     * @param argument The ETA (estimated time of arrival) for remediation (optional), see example
     */
    @JvmName("lowsssggrkpdsyha")
    public suspend fun remediationEta(argument: suspend RemediationEtaArgsBuilder.() -> Unit) {
        val toBeMapped = RemediationEtaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remediationEta = mapped
    }

    /**
     * @param value The scope of the Governance assignments. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
     */
    @JvmName("mwhnnwxkmqosrcjf")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): GovernanceAssignmentArgs = GovernanceAssignmentArgs(
        additionalData = additionalData,
        assessmentName = assessmentName,
        assignmentKey = assignmentKey,
        governanceEmailNotification = governanceEmailNotification,
        isGracePeriod = isGracePeriod,
        owner = owner,
        remediationDueDate = remediationDueDate,
        remediationEta = remediationEta,
        scope = scope,
    )
}
