@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleEmailNotificationResponse
import com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleMetadataResponse
import com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleOwnerSourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleEmailNotificationResponse.Companion.toKotlin as governanceRuleEmailNotificationResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleMetadataResponse.Companion.toKotlin as governanceRuleMetadataResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleOwnerSourceResponse.Companion.toKotlin as governanceRuleOwnerSourceResponseToKotlin

/**
 * Builder for [GovernanceRule].
 */
@PulumiTagMarker
public class GovernanceRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GovernanceRuleArgs = GovernanceRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GovernanceRuleArgsBuilder.() -> Unit) {
        val builder = GovernanceRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GovernanceRule {
        val builtJavaResource = com.pulumi.azurenative.security.GovernanceRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GovernanceRule(builtJavaResource)
    }
}

/**
 * Governance rule over a given scope
 * Azure REST API version: 2022-01-01-preview.
 * ## Example Usage
 * ### Create or update governance rule over management group scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var governanceRule = new AzureNative.Security.GovernanceRule("governanceRule", new()
 *     {
 *         Description = "A rule for a management group",
 *         DisplayName = "Management group rule",
 *         ExcludedScopes = new[]
 *         {
 *             "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         },
 *         GovernanceEmailNotification = new AzureNative.Security.Inputs.GovernanceRuleEmailNotificationArgs
 *         {
 *             DisableManagerEmailNotification = true,
 *             DisableOwnerEmailNotification = false,
 *         },
 *         IsDisabled = false,
 *         IsGracePeriod = true,
 *         OwnerSource = new AzureNative.Security.Inputs.GovernanceRuleOwnerSourceArgs
 *         {
 *             Type = AzureNative.Security.GovernanceRuleOwnerSourceType.Manually,
 *             Value = "user@contoso.com",
 *         },
 *         RemediationTimeframe = "7.00:00:00",
 *         RuleId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         RulePriority = 200,
 *         RuleType = AzureNative.Security.GovernanceRuleType.Integrated,
 *         Scope = "providers/Microsoft.Management/managementGroups/contoso",
 *         SourceResourceType = AzureNative.Security.GovernanceRuleSourceResourceType.Assessments,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewGovernanceRule(ctx, "governanceRule", &security.GovernanceRuleArgs{
 * 			Description: pulumi.String("A rule for a management group"),
 * 			DisplayName: pulumi.String("Management group rule"),
 * 			ExcludedScopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 			},
 * 			GovernanceEmailNotification: &security.GovernanceRuleEmailNotificationArgs{
 * 				DisableManagerEmailNotification: pulumi.Bool(true),
 * 				DisableOwnerEmailNotification:   pulumi.Bool(false),
 * 			},
 * 			IsDisabled:    pulumi.Bool(false),
 * 			IsGracePeriod: pulumi.Bool(true),
 * 			OwnerSource: &security.GovernanceRuleOwnerSourceArgs{
 * 				Type:  pulumi.String(security.GovernanceRuleOwnerSourceTypeManually),
 * 				Value: pulumi.String("user@contoso.com"),
 * 			},
 * 			RemediationTimeframe: pulumi.String("7.00:00:00"),
 * 			RuleId:               pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			RulePriority:         pulumi.Int(200),
 * 			RuleType:             pulumi.String(security.GovernanceRuleTypeIntegrated),
 * 			Scope:                pulumi.String("providers/Microsoft.Management/managementGroups/contoso"),
 * 			SourceResourceType:   pulumi.String(security.GovernanceRuleSourceResourceTypeAssessments),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.GovernanceRule;
 * import com.pulumi.azurenative.security.GovernanceRuleArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceRuleEmailNotificationArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceRuleOwnerSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var governanceRule = new GovernanceRule("governanceRule", GovernanceRuleArgs.builder()
 *             .description("A rule for a management group")
 *             .displayName("Management group rule")
 *             .excludedScopes("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .governanceEmailNotification(GovernanceRuleEmailNotificationArgs.builder()
 *                 .disableManagerEmailNotification(true)
 *                 .disableOwnerEmailNotification(false)
 *                 .build())
 *             .isDisabled(false)
 *             .isGracePeriod(true)
 *             .ownerSource(GovernanceRuleOwnerSourceArgs.builder()
 *                 .type("Manually")
 *                 .value("user@contoso.com")
 *                 .build())
 *             .remediationTimeframe("7.00:00:00")
 *             .ruleId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .rulePriority(200)
 *             .ruleType("Integrated")
 *             .scope("providers/Microsoft.Management/managementGroups/contoso")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update governance rule over security connector scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var governanceRule = new AzureNative.Security.GovernanceRule("governanceRule", new()
 *     {
 *         Description = "A rule on critical GCP recommendations",
 *         DisplayName = "GCP Admin's rule",
 *         GovernanceEmailNotification = new AzureNative.Security.Inputs.GovernanceRuleEmailNotificationArgs
 *         {
 *             DisableManagerEmailNotification = true,
 *             DisableOwnerEmailNotification = false,
 *         },
 *         IsDisabled = false,
 *         IsGracePeriod = true,
 *         OwnerSource = new AzureNative.Security.Inputs.GovernanceRuleOwnerSourceArgs
 *         {
 *             Type = AzureNative.Security.GovernanceRuleOwnerSourceType.Manually,
 *             Value = "user@contoso.com",
 *         },
 *         RemediationTimeframe = "7.00:00:00",
 *         RuleId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         RulePriority = 200,
 *         RuleType = AzureNative.Security.GovernanceRuleType.Integrated,
 *         Scope = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector",
 *         SourceResourceType = AzureNative.Security.GovernanceRuleSourceResourceType.Assessments,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewGovernanceRule(ctx, "governanceRule", &security.GovernanceRuleArgs{
 * 			Description: pulumi.String("A rule on critical GCP recommendations"),
 * 			DisplayName: pulumi.String("GCP Admin's rule"),
 * 			GovernanceEmailNotification: &security.GovernanceRuleEmailNotificationArgs{
 * 				DisableManagerEmailNotification: pulumi.Bool(true),
 * 				DisableOwnerEmailNotification:   pulumi.Bool(false),
 * 			},
 * 			IsDisabled:    pulumi.Bool(false),
 * 			IsGracePeriod: pulumi.Bool(true),
 * 			OwnerSource: &security.GovernanceRuleOwnerSourceArgs{
 * 				Type:  pulumi.String(security.GovernanceRuleOwnerSourceTypeManually),
 * 				Value: pulumi.String("user@contoso.com"),
 * 			},
 * 			RemediationTimeframe: pulumi.String("7.00:00:00"),
 * 			RuleId:               pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			RulePriority:         pulumi.Int(200),
 * 			RuleType:             pulumi.String(security.GovernanceRuleTypeIntegrated),
 * 			Scope:                pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector"),
 * 			SourceResourceType:   pulumi.String(security.GovernanceRuleSourceResourceTypeAssessments),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.GovernanceRule;
 * import com.pulumi.azurenative.security.GovernanceRuleArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceRuleEmailNotificationArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceRuleOwnerSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var governanceRule = new GovernanceRule("governanceRule", GovernanceRuleArgs.builder()
 *             .description("A rule on critical GCP recommendations")
 *             .displayName("GCP Admin's rule")
 *             .governanceEmailNotification(GovernanceRuleEmailNotificationArgs.builder()
 *                 .disableManagerEmailNotification(true)
 *                 .disableOwnerEmailNotification(false)
 *                 .build())
 *             .isDisabled(false)
 *             .isGracePeriod(true)
 *             .ownerSource(GovernanceRuleOwnerSourceArgs.builder()
 *                 .type("Manually")
 *                 .value("user@contoso.com")
 *                 .build())
 *             .remediationTimeframe("7.00:00:00")
 *             .ruleId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .rulePriority(200)
 *             .ruleType("Integrated")
 *             .scope("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update governance rule over subscription scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var governanceRule = new AzureNative.Security.GovernanceRule("governanceRule", new()
 *     {
 *         Description = "A rule for critical recommendations",
 *         DisplayName = "Admin's rule",
 *         GovernanceEmailNotification = new AzureNative.Security.Inputs.GovernanceRuleEmailNotificationArgs
 *         {
 *             DisableManagerEmailNotification = false,
 *             DisableOwnerEmailNotification = false,
 *         },
 *         IsDisabled = false,
 *         IsGracePeriod = true,
 *         OwnerSource = new AzureNative.Security.Inputs.GovernanceRuleOwnerSourceArgs
 *         {
 *             Type = AzureNative.Security.GovernanceRuleOwnerSourceType.Manually,
 *             Value = "user@contoso.com",
 *         },
 *         RemediationTimeframe = "7.00:00:00",
 *         RuleId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         RulePriority = 200,
 *         RuleType = AzureNative.Security.GovernanceRuleType.Integrated,
 *         Scope = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         SourceResourceType = AzureNative.Security.GovernanceRuleSourceResourceType.Assessments,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewGovernanceRule(ctx, "governanceRule", &security.GovernanceRuleArgs{
 * 			Description: pulumi.String("A rule for critical recommendations"),
 * 			DisplayName: pulumi.String("Admin's rule"),
 * 			GovernanceEmailNotification: &security.GovernanceRuleEmailNotificationArgs{
 * 				DisableManagerEmailNotification: pulumi.Bool(false),
 * 				DisableOwnerEmailNotification:   pulumi.Bool(false),
 * 			},
 * 			IsDisabled:    pulumi.Bool(false),
 * 			IsGracePeriod: pulumi.Bool(true),
 * 			OwnerSource: &security.GovernanceRuleOwnerSourceArgs{
 * 				Type:  pulumi.String(security.GovernanceRuleOwnerSourceTypeManually),
 * 				Value: pulumi.String("user@contoso.com"),
 * 			},
 * 			RemediationTimeframe: pulumi.String("7.00:00:00"),
 * 			RuleId:               pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			RulePriority:         pulumi.Int(200),
 * 			RuleType:             pulumi.String(security.GovernanceRuleTypeIntegrated),
 * 			Scope:                pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 			SourceResourceType:   pulumi.String(security.GovernanceRuleSourceResourceTypeAssessments),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.GovernanceRule;
 * import com.pulumi.azurenative.security.GovernanceRuleArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceRuleEmailNotificationArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceRuleOwnerSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var governanceRule = new GovernanceRule("governanceRule", GovernanceRuleArgs.builder()
 *             .description("A rule for critical recommendations")
 *             .displayName("Admin's rule")
 *             .governanceEmailNotification(GovernanceRuleEmailNotificationArgs.builder()
 *                 .disableManagerEmailNotification(false)
 *                 .disableOwnerEmailNotification(false)
 *                 .build())
 *             .isDisabled(false)
 *             .isGracePeriod(true)
 *             .ownerSource(GovernanceRuleOwnerSourceArgs.builder()
 *                 .type("Manually")
 *                 .value("user@contoso.com")
 *                 .build())
 *             .remediationTimeframe("7.00:00:00")
 *             .ruleId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .rulePriority(200)
 *             .ruleType("Integrated")
 *             .scope("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:GovernanceRule ad9a8e26-29d9-4829-bb30-e597a58cdbb8 /{scope}/providers/Microsoft.Security/governanceRules/{ruleId}
 * ```
 */
public class GovernanceRule internal constructor(
    override val javaResource: com.pulumi.azurenative.security.GovernanceRule,
) : KotlinCustomResource(javaResource, GovernanceRuleMapper) {
    /**
     * Description of the governance rule
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Display name of the governance rule
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Excluded scopes, filter out the descendants of the scope (on management scopes)
     */
    public val excludedScopes: Output<List<String>>?
        get() = javaResource.excludedScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
     */
    public val governanceEmailNotification: Output<GovernanceRuleEmailNotificationResponse>?
        get() = javaResource.governanceEmailNotification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    governanceRuleEmailNotificationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Defines whether the rule is management scope rule (master connector as a single scope or management scope)
     */
    public val includeMemberScopes: Output<Boolean>?
        get() = javaResource.includeMemberScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defines whether the rule is active/inactive
     */
    public val isDisabled: Output<Boolean>?
        get() = javaResource.isDisabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defines whether there is a grace period on the governance rule
     */
    public val isGracePeriod: Output<Boolean>?
        get() = javaResource.isGracePeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The governance rule metadata
     */
    public val metadata: Output<GovernanceRuleMetadataResponse>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    governanceRuleMetadataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The owner source for the governance rule - e.g. Manually by user@contoso.com - see example
     */
    public val ownerSource: Output<GovernanceRuleOwnerSourceResponse>
        get() = javaResource.ownerSource().applyValue({ args0 ->
            args0.let({ args0 ->
                governanceRuleOwnerSourceResponseToKotlin(args0)
            })
        })

    /**
     * Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
     */
    public val remediationTimeframe: Output<String>?
        get() = javaResource.remediationTimeframe().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The governance rule priority, priority to the lower number. Rules with the same priority on the same scope will not be allowed
     */
    public val rulePriority: Output<Int>
        get() = javaResource.rulePriority().applyValue({ args0 -> args0 })

    /**
     * The rule type of the governance rule, defines the source of the rule e.g. Integrated
     */
    public val ruleType: Output<String>
        get() = javaResource.ruleType().applyValue({ args0 -> args0 })

    /**
     * The governance rule source, what the rule affects, e.g. Assessments
     */
    public val sourceResourceType: Output<String>
        get() = javaResource.sourceResourceType().applyValue({ args0 -> args0 })

    /**
     * The tenantId (GUID)
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GovernanceRuleMapper : ResourceMapper<GovernanceRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.GovernanceRule::class == javaResource::class

    override fun map(javaResource: Resource): GovernanceRule = GovernanceRule(
        javaResource as
            com.pulumi.azurenative.security.GovernanceRule,
    )
}

/**
 * @see [GovernanceRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GovernanceRule].
 */
public suspend fun governanceRule(
    name: String,
    block: suspend GovernanceRuleResourceBuilder.() -> Unit,
): GovernanceRule {
    val builder = GovernanceRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GovernanceRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun governanceRule(name: String): GovernanceRule {
    val builder = GovernanceRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
