@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.SecurityContactPropertiesResponseAlertNotifications
import com.pulumi.azurenative.security.kotlin.outputs.SecurityContactPropertiesResponseNotificationsByRole
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.security.kotlin.outputs.SecurityContactPropertiesResponseAlertNotifications.Companion.toKotlin as securityContactPropertiesResponseAlertNotificationsToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SecurityContactPropertiesResponseNotificationsByRole.Companion.toKotlin as securityContactPropertiesResponseNotificationsByRoleToKotlin

/**
 * Builder for [SecurityContact].
 */
@PulumiTagMarker
public class SecurityContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityContactArgs = SecurityContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityContactArgsBuilder.() -> Unit) {
        val builder = SecurityContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityContact {
        val builtJavaResource = com.pulumi.azurenative.security.SecurityContact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityContact(builtJavaResource)
    }
}

/**
 * Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
 * Azure REST API version: 2020-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2017-08-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create security contact data
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityContact = new AzureNative.Security.SecurityContact("securityContact", new()
 *     {
 *         AlertNotifications = new AzureNative.Security.Inputs.SecurityContactPropertiesAlertNotificationsArgs
 *         {
 *             MinimalSeverity = AzureNative.Security.MinimalSeverity.Low,
 *             State = AzureNative.Security.State.On,
 *         },
 *         Emails = "john@contoso.com;jane@contoso.com",
 *         NotificationsByRole = new AzureNative.Security.Inputs.SecurityContactPropertiesNotificationsByRoleArgs
 *         {
 *             Roles = new[]
 *             {
 *                 AzureNative.Security.Roles.Owner,
 *             },
 *             State = AzureNative.Security.State.On,
 *         },
 *         Phone = "(214)275-4038",
 *         SecurityContactName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSecurityContact(ctx, "securityContact", &security.SecurityContactArgs{
 * 			AlertNotifications: &security.SecurityContactPropertiesAlertNotificationsArgs{
 * 				MinimalSeverity: pulumi.String(security.MinimalSeverityLow),
 * 				State:           pulumi.String(security.StateOn),
 * 			},
 * 			Emails: pulumi.String("john@contoso.com;jane@contoso.com"),
 * 			NotificationsByRole: &security.SecurityContactPropertiesNotificationsByRoleArgs{
 * 				Roles: pulumi.StringArray{
 * 					pulumi.String(security.RolesOwner),
 * 				},
 * 				State: pulumi.String(security.StateOn),
 * 			},
 * 			Phone:               pulumi.String("(214)275-4038"),
 * 			SecurityContactName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SecurityContact;
 * import com.pulumi.azurenative.security.SecurityContactArgs;
 * import com.pulumi.azurenative.security.inputs.SecurityContactPropertiesAlertNotificationsArgs;
 * import com.pulumi.azurenative.security.inputs.SecurityContactPropertiesNotificationsByRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityContact = new SecurityContact("securityContact", SecurityContactArgs.builder()
 *             .alertNotifications(SecurityContactPropertiesAlertNotificationsArgs.builder()
 *                 .minimalSeverity("Low")
 *                 .state("On")
 *                 .build())
 *             .emails("john@contoso.com;jane@contoso.com")
 *             .notificationsByRole(SecurityContactPropertiesNotificationsByRoleArgs.builder()
 *                 .roles("Owner")
 *                 .state("On")
 *                 .build())
 *             .phone("(214)275-4038")
 *             .securityContactName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SecurityContact default /subscriptions/{subscriptionId}/providers/Microsoft.Security/securityContacts/{securityContactName}
 * ```
 */
public class SecurityContact internal constructor(
    override val javaResource: com.pulumi.azurenative.security.SecurityContact,
) : KotlinCustomResource(javaResource, SecurityContactMapper) {
    /**
     * Defines whether to send email notifications about new security alerts
     */
    public val alertNotifications: Output<SecurityContactPropertiesResponseAlertNotifications>?
        get() = javaResource.alertNotifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    securityContactPropertiesResponseAlertNotificationsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in this security contact.
     */
    public val emails: Output<String>?
        get() = javaResource.emails().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
     */
    public val notificationsByRole: Output<SecurityContactPropertiesResponseNotificationsByRole>?
        get() = javaResource.notificationsByRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    securityContactPropertiesResponseNotificationsByRoleToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The security contact's phone number
     */
    public val phone: Output<String>?
        get() = javaResource.phone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityContactMapper : ResourceMapper<SecurityContact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.SecurityContact::class == javaResource::class

    override fun map(javaResource: Resource): SecurityContact = SecurityContact(
        javaResource as
            com.pulumi.azurenative.security.SecurityContact,
    )
}

/**
 * @see [SecurityContact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityContact].
 */
public suspend fun securityContact(
    name: String,
    block: suspend SecurityContactResourceBuilder.() -> Unit,
): SecurityContact {
    val builder = SecurityContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityContact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityContact(name: String): SecurityContact {
    val builder = SecurityContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
