@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerVulnerabilityAssessment].
 */
@PulumiTagMarker
public class ServerVulnerabilityAssessmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerVulnerabilityAssessmentArgs = ServerVulnerabilityAssessmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerVulnerabilityAssessmentArgsBuilder.() -> Unit) {
        val builder = ServerVulnerabilityAssessmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerVulnerabilityAssessment {
        val builtJavaResource =
            com.pulumi.azurenative.security.ServerVulnerabilityAssessment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerVulnerabilityAssessment(builtJavaResource)
    }
}

/**
 * Describes the server vulnerability assessment details on a resource
 * Azure REST API version: 2020-01-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create a server vulnerability assessments on a resource. Only 'default' resource is supported. Once creating the resource, the server will be onboarded to vulnerability assessment by Microsoft.Security
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverVulnerabilityAssessment = new AzureNative.Security.ServerVulnerabilityAssessment("serverVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "rg1",
 *         ResourceName = "vm1",
 *         ResourceNamespace = "Microsoft.Compute",
 *         ResourceType = "virtualMachines",
 *         ServerVulnerabilityAssessment = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewServerVulnerabilityAssessment(ctx, "serverVulnerabilityAssessment", &security.ServerVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 			ResourceName:                  pulumi.String("vm1"),
 * 			ResourceNamespace:             pulumi.String("Microsoft.Compute"),
 * 			ResourceType:                  pulumi.String("virtualMachines"),
 * 			ServerVulnerabilityAssessment: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.ServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.security.ServerVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverVulnerabilityAssessment = new ServerVulnerabilityAssessment("serverVulnerabilityAssessment", ServerVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("rg1")
 *             .resourceName("vm1")
 *             .resourceNamespace("Microsoft.Compute")
 *             .resourceType("virtualMachines")
 *             .serverVulnerabilityAssessment("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:ServerVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}
 * ```
 */
public class ServerVulnerabilityAssessment internal constructor(
    override val javaResource: com.pulumi.azurenative.security.ServerVulnerabilityAssessment,
) : KotlinCustomResource(javaResource, ServerVulnerabilityAssessmentMapper) {
    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioningState of the vulnerability assessment capability on the VM
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerVulnerabilityAssessmentMapper : ResourceMapper<ServerVulnerabilityAssessment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.ServerVulnerabilityAssessment::class == javaResource::class

    override fun map(javaResource: Resource): ServerVulnerabilityAssessment =
        ServerVulnerabilityAssessment(
            javaResource as
                com.pulumi.azurenative.security.ServerVulnerabilityAssessment,
        )
}

/**
 * @see [ServerVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerVulnerabilityAssessment].
 */
public suspend fun serverVulnerabilityAssessment(
    name: String,
    block: suspend ServerVulnerabilityAssessmentResourceBuilder.() -> Unit,
): ServerVulnerabilityAssessment {
    val builder = ServerVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverVulnerabilityAssessment(name: String): ServerVulnerabilityAssessment {
    val builder = ServerVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
