@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Programmatic code for the status of the assessment
 */
public enum class AssessmentStatusCode(
    public val javaValue: com.pulumi.azurenative.security.enums.AssessmentStatusCode,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.AssessmentStatusCode> {
    /**
     * The resource is healthy
     */
    Healthy(com.pulumi.azurenative.security.enums.AssessmentStatusCode.Healthy),

    /**
     * The resource has a security issue that needs to be addressed
     */
    Unhealthy(com.pulumi.azurenative.security.enums.AssessmentStatusCode.Unhealthy),

    /**
     * Assessment for this resource did not happen
     */
    NotApplicable(com.pulumi.azurenative.security.enums.AssessmentStatusCode.NotApplicable),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.AssessmentStatusCode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.AssessmentStatusCode): AssessmentStatusCode = AssessmentStatusCode.values().first { it.javaValue == javaType }
    }
}
