@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The categories of resource that is at risk when the assessment is unhealthy
 */
public enum class Categories(
    public val javaValue: com.pulumi.azurenative.security.enums.Categories,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.Categories> {
    Compute(com.pulumi.azurenative.security.enums.Categories.Compute),
    Networking(com.pulumi.azurenative.security.enums.Categories.Networking),
    Data(com.pulumi.azurenative.security.enums.Categories.Data),
    IdentityAndAccess(com.pulumi.azurenative.security.enums.Categories.IdentityAndAccess),
    IoT(com.pulumi.azurenative.security.enums.Categories.IoT),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.Categories = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.Categories): Categories =
            Categories.values().first { it.javaValue == javaType }
    }
}
