@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The governance rule source, what the rule affects, e.g. Assessments
 */
public enum class GovernanceRuleSourceResourceType(
    public val javaValue: com.pulumi.azurenative.security.enums.GovernanceRuleSourceResourceType,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.GovernanceRuleSourceResourceType> {
    /**
     * The source of the governance rule is assessments
     */
    Assessments(com.pulumi.azurenative.security.enums.GovernanceRuleSourceResourceType.Assessments),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.GovernanceRuleSourceResourceType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.GovernanceRuleSourceResourceType): GovernanceRuleSourceResourceType =
            GovernanceRuleSourceResourceType.values().first { it.javaValue == javaType }
    }
}
