@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The rule type of the governance rule, defines the source of the rule e.g. Integrated
 */
public enum class GovernanceRuleType(
    public val javaValue: com.pulumi.azurenative.security.enums.GovernanceRuleType,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.GovernanceRuleType> {
    /**
     * The source of the rule type definition is integrated
     */
    Integrated(com.pulumi.azurenative.security.enums.GovernanceRuleType.Integrated),

    /**
     * The source of the rule type definition is ServiceNow
     */
    ServiceNow(com.pulumi.azurenative.security.enums.GovernanceRuleType.ServiceNow),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.GovernanceRuleType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.GovernanceRuleType): GovernanceRuleType = GovernanceRuleType.values().first { it.javaValue == javaType }
    }
}
