@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the extension is enabled.
 */
public enum class IsEnabled(
    public val javaValue: com.pulumi.azurenative.security.enums.IsEnabled,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.IsEnabled> {
    /**
     * Indicates the extension is enabled
     */
    True(com.pulumi.azurenative.security.enums.IsEnabled.True),

    /**
     * Indicates the extension is disabled
     */
    False(com.pulumi.azurenative.security.enums.IsEnabled.False),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.IsEnabled = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.IsEnabled): IsEnabled =
            IsEnabled.values().first { it.javaValue == javaType }
    }
}
