@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines the minimal alert severity which will be sent as email notifications
 */
public enum class MinimalSeverity(
    public val javaValue: com.pulumi.azurenative.security.enums.MinimalSeverity,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.MinimalSeverity> {
    /**
     * Get notifications on new alerts with High severity
     */
    High(com.pulumi.azurenative.security.enums.MinimalSeverity.High),

    /**
     * Get notifications on new alerts with medium or high severity
     */
    Medium(com.pulumi.azurenative.security.enums.MinimalSeverity.Medium),

    /**
     * Don't get notifications on new alerts with low, medium or high severity
     */
    Low(com.pulumi.azurenative.security.enums.MinimalSeverity.Low),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.MinimalSeverity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.MinimalSeverity): MinimalSeverity = MinimalSeverity.values().first { it.javaValue == javaType }
    }
}
