@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
 */
public enum class Operator(
    public val javaValue: com.pulumi.azurenative.security.enums.Operator,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.Operator> {
    /**
     * Applies for decimal and non-decimal operands
     */
    Equals(com.pulumi.azurenative.security.enums.Operator.Equals),

    /**
     * Applies only for decimal operands
     */
    GreaterThan(com.pulumi.azurenative.security.enums.Operator.GreaterThan),

    /**
     * Applies only for decimal operands
     */
    GreaterThanOrEqualTo(com.pulumi.azurenative.security.enums.Operator.GreaterThanOrEqualTo),

    /**
     * Applies only for decimal operands
     */
    LesserThan(com.pulumi.azurenative.security.enums.Operator.LesserThan),

    /**
     * Applies only for decimal operands
     */
    LesserThanOrEqualTo(com.pulumi.azurenative.security.enums.Operator.LesserThanOrEqualTo),

    /**
     * Applies  for decimal and non-decimal operands
     */
    NotEquals(com.pulumi.azurenative.security.enums.Operator.NotEquals),

    /**
     * Applies only for non-decimal operands
     */
    Contains(com.pulumi.azurenative.security.enums.Operator.Contains),

    /**
     * Applies only for non-decimal operands
     */
    StartsWith(com.pulumi.azurenative.security.enums.Operator.StartsWith),

    /**
     * Applies only for non-decimal operands
     */
    EndsWith(com.pulumi.azurenative.security.enums.Operator.EndsWith),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.Operator = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.Operator): Operator =
            Operator.values().first { it.javaValue == javaType }
    }
}
