@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of IoT Security recommendation.
 */
public enum class RecommendationType(
    public val javaValue: com.pulumi.azurenative.security.enums.RecommendationType,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.RecommendationType> {
    /**
     * Authentication schema used for pull an edge module from an ACR repository does not use Service Principal Authentication.
     */
    IoT_ACRAuthentication(com.pulumi.azurenative.security.enums.RecommendationType.IoT_ACRAuthentication),

    /**
     * IoT agent message size capacity is currently underutilized, causing an increase in the number of sent messages. Adjust message intervals for better utilization.
     */
    IoT_AgentSendsUnutilizedMessages(com.pulumi.azurenative.security.enums.RecommendationType.IoT_AgentSendsUnutilizedMessages),

    /**
     * Identified security related system configuration issues.
     */
    IoT_Baseline(com.pulumi.azurenative.security.enums.RecommendationType.IoT_Baseline),

    /**
     * You can optimize Edge Hub memory usage by turning off protocol heads for any protocols not used by Edge modules in your solution.
     */
    IoT_EdgeHubMemOptimize(com.pulumi.azurenative.security.enums.RecommendationType.IoT_EdgeHubMemOptimize),

    /**
     * Logging is disabled for this edge module.
     */
    IoT_EdgeLoggingOptions(com.pulumi.azurenative.security.enums.RecommendationType.IoT_EdgeLoggingOptions),

    /**
     * A minority within a device security group has inconsistent Edge Module settings with the rest of their group.
     */
    IoT_InconsistentModuleSettings(com.pulumi.azurenative.security.enums.RecommendationType.IoT_InconsistentModuleSettings),

    /**
     * Install the Azure Security of Things Agent.
     */
    IoT_InstallAgent(com.pulumi.azurenative.security.enums.RecommendationType.IoT_InstallAgent),

    /**
     * IP Filter Configuration should have rules defined for allowed traffic and should deny all other traffic by default.
     */
    IoT_IPFilter_DenyAll(com.pulumi.azurenative.security.enums.RecommendationType.IoT_IPFilter_DenyAll),

    /**
     * An Allow IP Filter rules source IP range is too large. Overly permissive rules might expose your IoT hub to malicious intenders.
     */
    IoT_IPFilter_PermissiveRule(com.pulumi.azurenative.security.enums.RecommendationType.IoT_IPFilter_PermissiveRule),

    /**
     * A listening endpoint was found on the device.
     */
    IoT_OpenPorts(com.pulumi.azurenative.security.enums.RecommendationType.IoT_OpenPorts),

    /**
     * An Allowed firewall policy was found (INPUT/OUTPUT). The policy should Deny all traffic by default and define rules to allow necessary communication to/from the device.
     */
    IoT_PermissiveFirewallPolicy(com.pulumi.azurenative.security.enums.RecommendationType.IoT_PermissiveFirewallPolicy),

    /**
     * A rule in the firewall has been found that contains a permissive pattern for a wide range of IP addresses or Ports.
     */
    IoT_PermissiveInputFirewallRules(com.pulumi.azurenative.security.enums.RecommendationType.IoT_PermissiveInputFirewallRules),

    /**
     * A rule in the firewall has been found that contains a permissive pattern for a wide range of IP addresses or Ports.
     */
    IoT_PermissiveOutputFirewallRules(com.pulumi.azurenative.security.enums.RecommendationType.IoT_PermissiveOutputFirewallRules),

    /**
     * Edge module is configured to run in privileged mode, with extensive Linux capabilities or with host-level network access (send/receive data to host machine).
     */
    IoT_PrivilegedDockerOptions(com.pulumi.azurenative.security.enums.RecommendationType.IoT_PrivilegedDockerOptions),

    /**
     * Same authentication credentials to the IoT Hub used by multiple devices. This could indicate an illegitimate device impersonating a legitimate device. It also exposes the risk of device impersonation by an attacker.
     */
    IoT_SharedCredentials(com.pulumi.azurenative.security.enums.RecommendationType.IoT_SharedCredentials),

    /**
     * Insecure TLS configurations detected. Immediate upgrade recommended.
     */
    IoT_VulnerableTLSCipherSuite(com.pulumi.azurenative.security.enums.RecommendationType.IoT_VulnerableTLSCipherSuite),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.RecommendationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.RecommendationType): RecommendationType = RecommendationType.values().first { it.javaValue == javaType }
    }
}
