@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Possible states of the rule
 */
public enum class RuleState(
    public val javaValue: com.pulumi.azurenative.security.enums.RuleState,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.RuleState> {
    Enabled(com.pulumi.azurenative.security.enums.RuleState.Enabled),
    Disabled(com.pulumi.azurenative.security.enums.RuleState.Disabled),
    Expired(com.pulumi.azurenative.security.enums.RuleState.Expired),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.RuleState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.RuleState): RuleState =
            RuleState.values().first { it.javaValue == javaType }
    }
}
