@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The cloud that the standard is supported on.
 */
public enum class StandardSupportedClouds(
    public val javaValue: com.pulumi.azurenative.security.enums.StandardSupportedClouds,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.StandardSupportedClouds> {
    AWS(com.pulumi.azurenative.security.enums.StandardSupportedClouds.AWS),
    GCP(com.pulumi.azurenative.security.enums.StandardSupportedClouds.GCP),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.StandardSupportedClouds = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.StandardSupportedClouds): StandardSupportedClouds =
            StandardSupportedClouds.values().first { it.javaValue == javaType }
    }
}
