@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Threats impact of the assessment
 */
public enum class Threats(
    public val javaValue: com.pulumi.azurenative.security.enums.Threats,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.Threats> {
    AccountBreach(com.pulumi.azurenative.security.enums.Threats.AccountBreach),
    DataExfiltration(com.pulumi.azurenative.security.enums.Threats.DataExfiltration),
    DataSpillage(com.pulumi.azurenative.security.enums.Threats.DataSpillage),
    MaliciousInsider(com.pulumi.azurenative.security.enums.Threats.MaliciousInsider),
    ElevationOfPrivilege(com.pulumi.azurenative.security.enums.Threats.ElevationOfPrivilege),
    ThreatResistance(com.pulumi.azurenative.security.enums.Threats.ThreatResistance),
    MissingCoverage(com.pulumi.azurenative.security.enums.Threats.MissingCoverage),
    DenialOfService(com.pulumi.azurenative.security.enums.Threats.DenialOfService),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.Threats = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.Threats): Threats =
            Threats.values().first { it.javaValue == javaType }
    }
}
