@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Unmasked IP address logging status
 */
public enum class UnmaskedIpLoggingStatus(
    public val javaValue: com.pulumi.azurenative.security.enums.UnmaskedIpLoggingStatus,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.UnmaskedIpLoggingStatus> {
    /**
     * Unmasked IP logging is disabled
     */
    Disabled(com.pulumi.azurenative.security.enums.UnmaskedIpLoggingStatus.Disabled),

    /**
     * Unmasked IP logging is enabled
     */
    Enabled(com.pulumi.azurenative.security.enums.UnmaskedIpLoggingStatus.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.UnmaskedIpLoggingStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.UnmaskedIpLoggingStatus): UnmaskedIpLoggingStatus =
            UnmaskedIpLoggingStatus.values().first { it.javaValue == javaType }
    }
}
