@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AutomationSourceArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.EventSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The source event types which evaluate the security automation set of rules. For example - security alerts and security assessments. To learn more about the supported security events data models schemas - please visit https://aka.ms/ASCAutomationSchemas.
 * @property eventSource A valid event source type.
 * @property ruleSets A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
 */
public data class AutomationSourceArgs(
    public val eventSource: Output<Either<String, EventSource>>? = null,
    public val ruleSets: Output<List<AutomationRuleSetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AutomationSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AutomationSourceArgs =
        com.pulumi.azurenative.security.inputs.AutomationSourceArgs.builder()
            .eventSource(
                eventSource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ruleSets(
                ruleSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutomationSourceArgs].
 */
@PulumiTagMarker
public class AutomationSourceArgsBuilder internal constructor() {
    private var eventSource: Output<Either<String, EventSource>>? = null

    private var ruleSets: Output<List<AutomationRuleSetArgs>>? = null

    /**
     * @param value A valid event source type.
     */
    @JvmName("jgyxylohqhqoghdj")
    public suspend fun eventSource(`value`: Output<Either<String, EventSource>>) {
        this.eventSource = value
    }

    /**
     * @param value A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
     */
    @JvmName("wptgscqmabfbvksp")
    public suspend fun ruleSets(`value`: Output<List<AutomationRuleSetArgs>>) {
        this.ruleSets = value
    }

    @JvmName("mckhrlcmbqmqolga")
    public suspend fun ruleSets(vararg values: Output<AutomationRuleSetArgs>) {
        this.ruleSets = Output.all(values.asList())
    }

    /**
     * @param values A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
     */
    @JvmName("nvckbyaexueultpu")
    public suspend fun ruleSets(values: List<Output<AutomationRuleSetArgs>>) {
        this.ruleSets = Output.all(values)
    }

    /**
     * @param value A valid event source type.
     */
    @JvmName("ewhfqtbgtrjuuryi")
    public suspend fun eventSource(`value`: Either<String, EventSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSource = mapped
    }

    /**
     * @param value A valid event source type.
     */
    @JvmName("rlnponbbiisgcunv")
    public fun eventSource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSource = mapped
    }

    /**
     * @param value A valid event source type.
     */
    @JvmName("slbukhymdkwqixlx")
    public fun eventSource(`value`: EventSource) {
        val toBeMapped = Either.ofRight<String, EventSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSource = mapped
    }

    /**
     * @param value A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
     */
    @JvmName("rurjgqocgriecumj")
    public suspend fun ruleSets(`value`: List<AutomationRuleSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSets = mapped
    }

    /**
     * @param argument A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
     */
    @JvmName("swjwlqebyjpgukrh")
    public suspend fun ruleSets(argument: List<suspend AutomationRuleSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleSets = mapped
    }

    /**
     * @param argument A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
     */
    @JvmName("jpdtrsijbecnogwb")
    public suspend fun ruleSets(vararg argument: suspend AutomationRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleSets = mapped
    }

    /**
     * @param argument A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
     */
    @JvmName("wyutedehsagsyudg")
    public suspend fun ruleSets(argument: suspend AutomationRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AutomationRuleSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ruleSets = mapped
    }

    /**
     * @param values A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
     */
    @JvmName("guecnptkxjydcrpa")
    public suspend fun ruleSets(vararg values: AutomationRuleSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSets = mapped
    }

    internal fun build(): AutomationSourceArgs = AutomationSourceArgs(
        eventSource = eventSource,
        ruleSets = ruleSets,
    )
}
