@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AwsCredsAuthenticationDetailsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AWS cloud account connector based credentials, the credentials is composed of access key ID and secret key, for more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM User in Your AWS Account (write only)</a>
 * @property authenticationType Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
 * Expected value is 'awsCreds'.
 * @property awsAccessKeyId Public key element of the AWS credential object (write only)
 * @property awsSecretAccessKey Secret key element of the AWS credential object (write only)
 */
public data class AwsCredsAuthenticationDetailsPropertiesArgs(
    public val authenticationType: Output<String>,
    public val awsAccessKeyId: Output<String>,
    public val awsSecretAccessKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.AwsCredsAuthenticationDetailsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AwsCredsAuthenticationDetailsPropertiesArgs =
        com.pulumi.azurenative.security.inputs.AwsCredsAuthenticationDetailsPropertiesArgs.builder()
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .awsAccessKeyId(awsAccessKeyId.applyValue({ args0 -> args0 }))
            .awsSecretAccessKey(awsSecretAccessKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AwsCredsAuthenticationDetailsPropertiesArgs].
 */
@PulumiTagMarker
public class AwsCredsAuthenticationDetailsPropertiesArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    private var awsAccessKeyId: Output<String>? = null

    private var awsSecretAccessKey: Output<String>? = null

    /**
     * @param value Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
     * Expected value is 'awsCreds'.
     */
    @JvmName("xjotnwhyrpnvtpxr")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Public key element of the AWS credential object (write only)
     */
    @JvmName("xybjpgbeuyidipos")
    public suspend fun awsAccessKeyId(`value`: Output<String>) {
        this.awsAccessKeyId = value
    }

    /**
     * @param value Secret key element of the AWS credential object (write only)
     */
    @JvmName("ndaodqyxmuwukqib")
    public suspend fun awsSecretAccessKey(`value`: Output<String>) {
        this.awsSecretAccessKey = value
    }

    /**
     * @param value Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
     * Expected value is 'awsCreds'.
     */
    @JvmName("syngfjrgewaksawk")
    public suspend fun authenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Public key element of the AWS credential object (write only)
     */
    @JvmName("ewrxgvsysnyaqyhe")
    public suspend fun awsAccessKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsAccessKeyId = mapped
    }

    /**
     * @param value Secret key element of the AWS credential object (write only)
     */
    @JvmName("xsmwhahmqaowdskf")
    public suspend fun awsSecretAccessKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsSecretAccessKey = mapped
    }

    internal fun build(): AwsCredsAuthenticationDetailsPropertiesArgs =
        AwsCredsAuthenticationDetailsPropertiesArgs(
            authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
            awsAccessKeyId = awsAccessKeyId ?: throw PulumiNullFieldException("awsAccessKeyId"),
            awsSecretAccessKey = awsSecretAccessKey ?: throw PulumiNullFieldException("awsSecretAccessKey"),
        )
}
