@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AwsOrganizationalDataMasterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The AWS organization data for the master account
 * @property excludedAccountIds If the multi cloud account is of membership type organization, list of accounts excluded from offering
 * @property organizationMembershipType The multi cloud account's membership type in the organization
 * Expected value is 'Organization'.
 * @property stacksetName If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
 */
public data class AwsOrganizationalDataMasterArgs(
    public val excludedAccountIds: Output<List<String>>? = null,
    public val organizationMembershipType: Output<String>,
    public val stacksetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AwsOrganizationalDataMasterArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AwsOrganizationalDataMasterArgs =
        com.pulumi.azurenative.security.inputs.AwsOrganizationalDataMasterArgs.builder()
            .excludedAccountIds(excludedAccountIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .organizationMembershipType(organizationMembershipType.applyValue({ args0 -> args0 }))
            .stacksetName(stacksetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AwsOrganizationalDataMasterArgs].
 */
@PulumiTagMarker
public class AwsOrganizationalDataMasterArgsBuilder internal constructor() {
    private var excludedAccountIds: Output<List<String>>? = null

    private var organizationMembershipType: Output<String>? = null

    private var stacksetName: Output<String>? = null

    /**
     * @param value If the multi cloud account is of membership type organization, list of accounts excluded from offering
     */
    @JvmName("gcvtlnmjbiofleeh")
    public suspend fun excludedAccountIds(`value`: Output<List<String>>) {
        this.excludedAccountIds = value
    }

    @JvmName("mukvokhkxktrhevf")
    public suspend fun excludedAccountIds(vararg values: Output<String>) {
        this.excludedAccountIds = Output.all(values.asList())
    }

    /**
     * @param values If the multi cloud account is of membership type organization, list of accounts excluded from offering
     */
    @JvmName("garpvndqkmpcxnxw")
    public suspend fun excludedAccountIds(values: List<Output<String>>) {
        this.excludedAccountIds = Output.all(values)
    }

    /**
     * @param value The multi cloud account's membership type in the organization
     * Expected value is 'Organization'.
     */
    @JvmName("ehjsloimdpgaedxi")
    public suspend fun organizationMembershipType(`value`: Output<String>) {
        this.organizationMembershipType = value
    }

    /**
     * @param value If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
     */
    @JvmName("icsufeixsqqawfpa")
    public suspend fun stacksetName(`value`: Output<String>) {
        this.stacksetName = value
    }

    /**
     * @param value If the multi cloud account is of membership type organization, list of accounts excluded from offering
     */
    @JvmName("etwsfnltibpjbqlx")
    public suspend fun excludedAccountIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedAccountIds = mapped
    }

    /**
     * @param values If the multi cloud account is of membership type organization, list of accounts excluded from offering
     */
    @JvmName("ckewomjppgdwvocg")
    public suspend fun excludedAccountIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedAccountIds = mapped
    }

    /**
     * @param value The multi cloud account's membership type in the organization
     * Expected value is 'Organization'.
     */
    @JvmName("qghyemhxyflttjxp")
    public suspend fun organizationMembershipType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationMembershipType = mapped
    }

    /**
     * @param value If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
     */
    @JvmName("jwtiensngnbvucfc")
    public suspend fun stacksetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stacksetName = mapped
    }

    internal fun build(): AwsOrganizationalDataMasterArgs = AwsOrganizationalDataMasterArgs(
        excludedAccountIds = excludedAccountIds,
        organizationMembershipType = organizationMembershipType ?: throw
            PulumiNullFieldException("organizationMembershipType"),
        stacksetName = stacksetName,
    )
}
