@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AwsOrganizationalDataMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AWS organization data for the member account
 * @property organizationMembershipType The multi cloud account's membership type in the organization
 * Expected value is 'Member'.
 * @property parentHierarchyId If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
 */
public data class AwsOrganizationalDataMemberArgs(
    public val organizationMembershipType: Output<String>,
    public val parentHierarchyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AwsOrganizationalDataMemberArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AwsOrganizationalDataMemberArgs =
        com.pulumi.azurenative.security.inputs.AwsOrganizationalDataMemberArgs.builder()
            .organizationMembershipType(organizationMembershipType.applyValue({ args0 -> args0 }))
            .parentHierarchyId(parentHierarchyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AwsOrganizationalDataMemberArgs].
 */
@PulumiTagMarker
public class AwsOrganizationalDataMemberArgsBuilder internal constructor() {
    private var organizationMembershipType: Output<String>? = null

    private var parentHierarchyId: Output<String>? = null

    /**
     * @param value The multi cloud account's membership type in the organization
     * Expected value is 'Member'.
     */
    @JvmName("xybnmvfdrqjlcsaa")
    public suspend fun organizationMembershipType(`value`: Output<String>) {
        this.organizationMembershipType = value
    }

    /**
     * @param value If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
     */
    @JvmName("hunjnnjehcosahnm")
    public suspend fun parentHierarchyId(`value`: Output<String>) {
        this.parentHierarchyId = value
    }

    /**
     * @param value The multi cloud account's membership type in the organization
     * Expected value is 'Member'.
     */
    @JvmName("edshslwdlsdhsiib")
    public suspend fun organizationMembershipType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationMembershipType = mapped
    }

    /**
     * @param value If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
     */
    @JvmName("ualjiioostwsgyab")
    public suspend fun parentHierarchyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentHierarchyId = mapped
    }

    internal fun build(): AwsOrganizationalDataMemberArgs = AwsOrganizationalDataMemberArgs(
        organizationMembershipType = organizationMembershipType ?: throw
            PulumiNullFieldException("organizationMembershipType"),
        parentHierarchyId = parentHierarchyId,
    )
}
