@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The CSPM P1 for AWS offering
 * @property dataSensitivityDiscovery The Microsoft Defender Data Sensitivity discovery configuration
 * @property databasesDspm The databases DSPM configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderCspmAws'.
 * @property vmScanners The Microsoft Defender for Server VM scanning configuration
 */
public data class DefenderCspmAwsOfferingArgs(
    public val dataSensitivityDiscovery: Output<DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs>? =
        null,
    public val databasesDspm: Output<DefenderCspmAwsOfferingDatabasesDspmArgs>? = null,
    public val offeringType: Output<String>,
    public val vmScanners: Output<DefenderCspmAwsOfferingVmScannersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingArgs.builder()
            .dataSensitivityDiscovery(
                dataSensitivityDiscovery?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .databasesDspm(databasesDspm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .offeringType(offeringType.applyValue({ args0 -> args0 }))
            .vmScanners(vmScanners?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DefenderCspmAwsOfferingArgs].
 */
@PulumiTagMarker
public class DefenderCspmAwsOfferingArgsBuilder internal constructor() {
    private var dataSensitivityDiscovery: Output<DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs>? =
        null

    private var databasesDspm: Output<DefenderCspmAwsOfferingDatabasesDspmArgs>? = null

    private var offeringType: Output<String>? = null

    private var vmScanners: Output<DefenderCspmAwsOfferingVmScannersArgs>? = null

    /**
     * @param value The Microsoft Defender Data Sensitivity discovery configuration
     */
    @JvmName("qhsenvsdaxomwrma")
    public suspend fun dataSensitivityDiscovery(`value`: Output<DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs>) {
        this.dataSensitivityDiscovery = value
    }

    /**
     * @param value The databases DSPM configuration
     */
    @JvmName("epmegvckegqfnpnv")
    public suspend fun databasesDspm(`value`: Output<DefenderCspmAwsOfferingDatabasesDspmArgs>) {
        this.databasesDspm = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderCspmAws'.
     */
    @JvmName("vibaeugbmbeydmxb")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("dinqjbpqptfnante")
    public suspend fun vmScanners(`value`: Output<DefenderCspmAwsOfferingVmScannersArgs>) {
        this.vmScanners = value
    }

    /**
     * @param value The Microsoft Defender Data Sensitivity discovery configuration
     */
    @JvmName("vckfegnlxviygnaj")
    public suspend fun dataSensitivityDiscovery(`value`: DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSensitivityDiscovery = mapped
    }

    /**
     * @param argument The Microsoft Defender Data Sensitivity discovery configuration
     */
    @JvmName("ycmuktavnlnafacx")
    public suspend fun dataSensitivityDiscovery(argument: suspend DefenderCspmAwsOfferingDataSensitivityDiscoveryArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderCspmAwsOfferingDataSensitivityDiscoveryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataSensitivityDiscovery = mapped
    }

    /**
     * @param value The databases DSPM configuration
     */
    @JvmName("ajxqfvrdnytbwewb")
    public suspend fun databasesDspm(`value`: DefenderCspmAwsOfferingDatabasesDspmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databasesDspm = mapped
    }

    /**
     * @param argument The databases DSPM configuration
     */
    @JvmName("xwxilxlykfleepdw")
    public suspend fun databasesDspm(argument: suspend DefenderCspmAwsOfferingDatabasesDspmArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderCspmAwsOfferingDatabasesDspmArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.databasesDspm = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderCspmAws'.
     */
    @JvmName("bluqqpdqwfjkroxv")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    /**
     * @param value The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("xpatkjwcypmywyto")
    public suspend fun vmScanners(`value`: DefenderCspmAwsOfferingVmScannersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmScanners = mapped
    }

    /**
     * @param argument The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("cqjihfrgqojydjxj")
    public suspend fun vmScanners(argument: suspend DefenderCspmAwsOfferingVmScannersArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderCspmAwsOfferingVmScannersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vmScanners = mapped
    }

    internal fun build(): DefenderCspmAwsOfferingArgs = DefenderCspmAwsOfferingArgs(
        dataSensitivityDiscovery = dataSensitivityDiscovery,
        databasesDspm = databasesDspm,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
        vmScanners = vmScanners,
    )
}
