@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingConfigurationArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.ScanningMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * configuration for Microsoft Defender for Server VM scanning
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 * @property exclusionTags VM tags that indicates that VM should not be scanned
 * @property scanningMode The scanning mode for the VM scan.
 */
public data class DefenderCspmAwsOfferingConfigurationArgs(
    public val cloudRoleArn: Output<String>? = null,
    public val exclusionTags: Output<Map<String, String>>? = null,
    public val scanningMode: Output<Either<String, ScanningMode>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingConfigurationArgs =
        com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingConfigurationArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 }))
            .exclusionTags(
                exclusionTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .scanningMode(
                scanningMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DefenderCspmAwsOfferingConfigurationArgs].
 */
@PulumiTagMarker
public class DefenderCspmAwsOfferingConfigurationArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    private var exclusionTags: Output<Map<String, String>>? = null

    private var scanningMode: Output<Either<String, ScanningMode>>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("oufrfodxdspnjsjw")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value VM tags that indicates that VM should not be scanned
     */
    @JvmName("tgvsgpksnojioniw")
    public suspend fun exclusionTags(`value`: Output<Map<String, String>>) {
        this.exclusionTags = value
    }

    /**
     * @param value The scanning mode for the VM scan.
     */
    @JvmName("nyskinwcchwfprsc")
    public suspend fun scanningMode(`value`: Output<Either<String, ScanningMode>>) {
        this.scanningMode = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("ihqfdvsakufhupsx")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    /**
     * @param value VM tags that indicates that VM should not be scanned
     */
    @JvmName("pjjbqnnceaaqmunl")
    public suspend fun exclusionTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusionTags = mapped
    }

    /**
     * @param values VM tags that indicates that VM should not be scanned
     */
    @JvmName("cdipkxbyvcktiroc")
    public fun exclusionTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusionTags = mapped
    }

    /**
     * @param value The scanning mode for the VM scan.
     */
    @JvmName("yxdtpsibnupjabii")
    public suspend fun scanningMode(`value`: Either<String, ScanningMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanningMode = mapped
    }

    /**
     * @param value The scanning mode for the VM scan.
     */
    @JvmName("feudbqfvdysqjess")
    public fun scanningMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScanningMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanningMode = mapped
    }

    /**
     * @param value The scanning mode for the VM scan.
     */
    @JvmName("wyqmrnhnihwyywdu")
    public fun scanningMode(`value`: ScanningMode) {
        val toBeMapped = Either.ofRight<String, ScanningMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanningMode = mapped
    }

    internal fun build(): DefenderCspmAwsOfferingConfigurationArgs =
        DefenderCspmAwsOfferingConfigurationArgs(
            cloudRoleArn = cloudRoleArn,
            exclusionTags = exclusionTags,
            scanningMode = scanningMode,
        )
}
