@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderCspmGcpOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The CSPM P1 for GCP offering
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderCspmGcp'.
 */
public data class DefenderCspmGcpOfferingArgs(
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderCspmGcpOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderCspmGcpOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderCspmGcpOfferingArgs.builder()
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderCspmGcpOfferingArgs].
 */
@PulumiTagMarker
public class DefenderCspmGcpOfferingArgsBuilder internal constructor() {
    private var offeringType: Output<String>? = null

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderCspmGcp'.
     */
    @JvmName("tpqhmkwxaqtqjbpx")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderCspmGcp'.
     */
    @JvmName("pmsdmmxkbmtrcwgr")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): DefenderCspmGcpOfferingArgs = DefenderCspmGcpOfferingArgs(
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
