@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKinesisToS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The kinesis to s3 connection configuration
 * @property cloudRoleArn The cloud role ARN in AWS used by Kinesis to transfer data into S3
 */
public data class DefenderForContainersAwsOfferingKinesisToS3Args(
    public val cloudRoleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKinesisToS3Args> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKinesisToS3Args =
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKinesisToS3Args.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForContainersAwsOfferingKinesisToS3Args].
 */
@PulumiTagMarker
public class DefenderForContainersAwsOfferingKinesisToS3ArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    /**
     * @param value The cloud role ARN in AWS used by Kinesis to transfer data into S3
     */
    @JvmName("jjlpwaxddkikdhbl")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value The cloud role ARN in AWS used by Kinesis to transfer data into S3
     */
    @JvmName("erebjpawxbvgrfwx")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    internal fun build(): DefenderForContainersAwsOfferingKinesisToS3Args =
        DefenderForContainersAwsOfferingKinesisToS3Args(
            cloudRoleArn = cloudRoleArn,
        )
}
