@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration for servers Arc auto provisioning
 * @property privateLinkScope Optional Arc private link scope resource id to link the Arc agent
 * @property proxy Optional HTTP proxy endpoint to use for the Arc agent
 */
public data class DefenderForServersAwsOfferingConfigurationArgs(
    public val privateLinkScope: Output<String>? = null,
    public val proxy: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingConfigurationArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingConfigurationArgs.builder()
            .privateLinkScope(privateLinkScope?.applyValue({ args0 -> args0 }))
            .proxy(proxy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersAwsOfferingConfigurationArgs].
 */
@PulumiTagMarker
public class DefenderForServersAwsOfferingConfigurationArgsBuilder internal constructor() {
    private var privateLinkScope: Output<String>? = null

    private var proxy: Output<String>? = null

    /**
     * @param value Optional Arc private link scope resource id to link the Arc agent
     */
    @JvmName("pcgiqcbdjiyhtnoy")
    public suspend fun privateLinkScope(`value`: Output<String>) {
        this.privateLinkScope = value
    }

    /**
     * @param value Optional HTTP proxy endpoint to use for the Arc agent
     */
    @JvmName("ftbvdycjjwbyprut")
    public suspend fun proxy(`value`: Output<String>) {
        this.proxy = value
    }

    /**
     * @param value Optional Arc private link scope resource id to link the Arc agent
     */
    @JvmName("ixdpeehlmiufvvwx")
    public suspend fun privateLinkScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkScope = mapped
    }

    /**
     * @param value Optional HTTP proxy endpoint to use for the Arc agent
     */
    @JvmName("tuomorrymygoutii")
    public suspend fun proxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxy = mapped
    }

    internal fun build(): DefenderForServersAwsOfferingConfigurationArgs =
        DefenderForServersAwsOfferingConfigurationArgs(
            privateLinkScope = privateLinkScope,
            proxy = proxy,
        )
}
