@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingConfigurationConfigurationArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * configuration for Vulnerability Assessment autoprovisioning
 * @property type The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
 */
public data class DefenderForServersGcpOfferingConfigurationConfigurationArgs(
    public val type: Output<Either<String, Type>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingConfigurationConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingConfigurationConfigurationArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingConfigurationConfigurationArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DefenderForServersGcpOfferingConfigurationConfigurationArgs].
 */
@PulumiTagMarker
public class DefenderForServersGcpOfferingConfigurationConfigurationArgsBuilder internal constructor() {
    private var type: Output<Either<String, Type>>? = null

    /**
     * @param value The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
     */
    @JvmName("pgyskdoxvdyafgdc")
    public suspend fun type(`value`: Output<Either<String, Type>>) {
        this.type = value
    }

    /**
     * @param value The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
     */
    @JvmName("ebtkwglbbnqyhcwb")
    public suspend fun type(`value`: Either<String, Type>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
     */
    @JvmName("ucyyakqecgcynmeo")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
     */
    @JvmName("atebflfvljwwqgqq")
    public fun type(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DefenderForServersGcpOfferingConfigurationConfigurationArgs =
        DefenderForServersGcpOfferingConfigurationConfigurationArgs(
            type = type,
        )
}
