@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingVaAutoProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Vulnerability Assessment autoprovisioning configuration
 * @property configuration configuration for Vulnerability Assessment autoprovisioning
 * @property enabled Is Vulnerability Assessment auto provisioning enabled
 */
public data class DefenderForServersGcpOfferingVaAutoProvisioningArgs(
    public val configuration: Output<DefenderForServersGcpOfferingConfigurationConfigurationArgs>? =
        null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingVaAutoProvisioningArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingVaAutoProvisioningArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingVaAutoProvisioningArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersGcpOfferingVaAutoProvisioningArgs].
 */
@PulumiTagMarker
public class DefenderForServersGcpOfferingVaAutoProvisioningArgsBuilder internal constructor() {
    private var configuration: Output<DefenderForServersGcpOfferingConfigurationConfigurationArgs>? =
        null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value configuration for Vulnerability Assessment autoprovisioning
     */
    @JvmName("tnpqpqfjnbvslbtn")
    public suspend fun configuration(`value`: Output<DefenderForServersGcpOfferingConfigurationConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is Vulnerability Assessment auto provisioning enabled
     */
    @JvmName("csmoylyuymexlaxd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value configuration for Vulnerability Assessment autoprovisioning
     */
    @JvmName("hparkbwtdfcwwbqe")
    public suspend fun configuration(`value`: DefenderForServersGcpOfferingConfigurationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument configuration for Vulnerability Assessment autoprovisioning
     */
    @JvmName("mslamtgrhracmcox")
    public suspend fun configuration(argument: suspend DefenderForServersGcpOfferingConfigurationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DefenderForServersGcpOfferingConfigurationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is Vulnerability Assessment auto provisioning enabled
     */
    @JvmName("sbsilybgjvnnrkqb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderForServersGcpOfferingVaAutoProvisioningArgs =
        DefenderForServersGcpOfferingVaAutoProvisioningArgs(
            configuration = configuration,
            enabled = enabled,
        )
}
