@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DevOpsPolicyAssignmentPropertiesArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.DescendantBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the DevOps policy assignment resource.
 * @property assignedAt Gets or sets time when the assignment was created in UTC.
 * @property descendantBehavior The behavior of a policy on descendant resources.
 * @property policy Condensed information to identify a DevOps Policy resource.
 * @property resourceId Gets or sets the Azure resource id.
 */
public data class DevOpsPolicyAssignmentPropertiesArgs(
    public val assignedAt: Output<String>? = null,
    public val descendantBehavior: Output<Either<String, DescendantBehavior>>? = null,
    public val policy: Output<DevOpsPolicyDescriptorArgs>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DevOpsPolicyAssignmentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DevOpsPolicyAssignmentPropertiesArgs = com.pulumi.azurenative.security.inputs.DevOpsPolicyAssignmentPropertiesArgs.builder()
        .assignedAt(assignedAt?.applyValue({ args0 -> args0 }))
        .descendantBehavior(
            descendantBehavior?.applyValue({ args0 ->
                args0.transform(
                    { args0 -> args0 },
                    { args0 -> args0.let({ args0 -> args0.toJava() }) },
                )
            }),
        )
        .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevOpsPolicyAssignmentPropertiesArgs].
 */
@PulumiTagMarker
public class DevOpsPolicyAssignmentPropertiesArgsBuilder internal constructor() {
    private var assignedAt: Output<String>? = null

    private var descendantBehavior: Output<Either<String, DescendantBehavior>>? = null

    private var policy: Output<DevOpsPolicyDescriptorArgs>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Gets or sets time when the assignment was created in UTC.
     */
    @JvmName("gwdguxcammsveafi")
    public suspend fun assignedAt(`value`: Output<String>) {
        this.assignedAt = value
    }

    /**
     * @param value The behavior of a policy on descendant resources.
     */
    @JvmName("jfeymnphdpiabxoa")
    public suspend fun descendantBehavior(`value`: Output<Either<String, DescendantBehavior>>) {
        this.descendantBehavior = value
    }

    /**
     * @param value Condensed information to identify a DevOps Policy resource.
     */
    @JvmName("hjdggddfnplkuumq")
    public suspend fun policy(`value`: Output<DevOpsPolicyDescriptorArgs>) {
        this.policy = value
    }

    /**
     * @param value Gets or sets the Azure resource id.
     */
    @JvmName("aajfkilgyrqgsvbh")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Gets or sets time when the assignment was created in UTC.
     */
    @JvmName("xctqrbmasbqxggew")
    public suspend fun assignedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedAt = mapped
    }

    /**
     * @param value The behavior of a policy on descendant resources.
     */
    @JvmName("oaffdbrbmhjqaftu")
    public suspend fun descendantBehavior(`value`: Either<String, DescendantBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.descendantBehavior = mapped
    }

    /**
     * @param value The behavior of a policy on descendant resources.
     */
    @JvmName("klnadjcvrmghtcta")
    public fun descendantBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DescendantBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.descendantBehavior = mapped
    }

    /**
     * @param value The behavior of a policy on descendant resources.
     */
    @JvmName("vejkpqhpyyqsfhfx")
    public fun descendantBehavior(`value`: DescendantBehavior) {
        val toBeMapped = Either.ofRight<String, DescendantBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.descendantBehavior = mapped
    }

    /**
     * @param value Condensed information to identify a DevOps Policy resource.
     */
    @JvmName("gbaatuxdweoyudtl")
    public suspend fun policy(`value`: DevOpsPolicyDescriptorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Condensed information to identify a DevOps Policy resource.
     */
    @JvmName("kgafpyujhdtcurjn")
    public suspend fun policy(argument: suspend DevOpsPolicyDescriptorArgsBuilder.() -> Unit) {
        val toBeMapped = DevOpsPolicyDescriptorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Gets or sets the Azure resource id.
     */
    @JvmName("buaeiufrfdjbucnp")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): DevOpsPolicyAssignmentPropertiesArgs = DevOpsPolicyAssignmentPropertiesArgs(
        assignedAt = assignedAt,
        descendantBehavior = descendantBehavior,
        policy = policy,
        resourceId = resourceId,
    )
}
