@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DevOpsPolicyDescriptorArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.DevOpsPolicyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Condensed information to identify a DevOps Policy resource.
 * @property policyId Gets or sets the policy GUID.
 * @property policyName Gets or sets the policy name.
 * @property policyType DevOps Policy resource types.
 * @property policyVersion Gets or sets the version.
 */
public data class DevOpsPolicyDescriptorArgs(
    public val policyId: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val policyType: Output<Either<String, DevOpsPolicyType>>? = null,
    public val policyVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DevOpsPolicyDescriptorArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DevOpsPolicyDescriptorArgs =
        com.pulumi.azurenative.security.inputs.DevOpsPolicyDescriptorArgs.builder()
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyVersion(policyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevOpsPolicyDescriptorArgs].
 */
@PulumiTagMarker
public class DevOpsPolicyDescriptorArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var policyName: Output<String>? = null

    private var policyType: Output<Either<String, DevOpsPolicyType>>? = null

    private var policyVersion: Output<String>? = null

    /**
     * @param value Gets or sets the policy GUID.
     */
    @JvmName("jqvhigxtlphpgdxv")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Gets or sets the policy name.
     */
    @JvmName("qghinhpjqolboipa")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value DevOps Policy resource types.
     */
    @JvmName("bahfsromdfaknqmh")
    public suspend fun policyType(`value`: Output<Either<String, DevOpsPolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value Gets or sets the version.
     */
    @JvmName("npkdmyulrqfsdceb")
    public suspend fun policyVersion(`value`: Output<String>) {
        this.policyVersion = value
    }

    /**
     * @param value Gets or sets the policy GUID.
     */
    @JvmName("epxlcvbhadmcdssv")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Gets or sets the policy name.
     */
    @JvmName("vvfnectdwvjlhood")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value DevOps Policy resource types.
     */
    @JvmName("vjylahxfeeyswxwm")
    public suspend fun policyType(`value`: Either<String, DevOpsPolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value DevOps Policy resource types.
     */
    @JvmName("lkwnanrpxapdwomm")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DevOpsPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value DevOps Policy resource types.
     */
    @JvmName("gcfcqrewihdmdsok")
    public fun policyType(`value`: DevOpsPolicyType) {
        val toBeMapped = Either.ofRight<String, DevOpsPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Gets or sets the version.
     */
    @JvmName("fwbahlmcmhsvwbxq")
    public suspend fun policyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyVersion = mapped
    }

    internal fun build(): DevOpsPolicyDescriptorArgs = DevOpsPolicyDescriptorArgs(
        policyId = policyId,
        policyName = policyName,
        policyType = policyType,
        policyVersion = policyVersion,
    )
}
