@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.ExtensionArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.IsEnabled
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A plan's extension properties
 * @property additionalExtensionProperties Property values associated with the extension.
 * @property isEnabled Indicates whether the extension is enabled.
 * @property name The extension name. Supported values are: <br><br>**AgentlessDiscoveryForKubernetes** - API-based discovery of information about Kubernetes cluster architecture, workload objects, and setup. Required for Kubernetes inventory, identity and network exposure detection, attack path analysis and risk hunting as part of the cloud security explorer.
 * Available for CloudPosture plan.<br><br>**OnUploadMalwareScanning** - Limits the GB to be scanned per month for each storage account within the subscription. Once this limit reached on a given storage account, Blobs won't be scanned during current calendar month.
 * Available for StorageAccounts plan.<br><br>**SensitiveDataDiscovery** - Sensitive data discovery identifies Blob storage container with sensitive data such as credentials, credit cards, and more, to help prioritize and investigate security events.
 * Available for StorageAccounts and CloudPosture plans.<br><br>**ContainerRegistriesVulnerabilityAssessments** - Provides vulnerability management for images stored in your container registries.
 * Available for CloudPosture and Containers plans.
 */
public data class ExtensionArgs(
    public val additionalExtensionProperties: Output<Any>? = null,
    public val isEnabled: Output<Either<String, IsEnabled>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.ExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.ExtensionArgs =
        com.pulumi.azurenative.security.inputs.ExtensionArgs.builder()
            .additionalExtensionProperties(additionalExtensionProperties?.applyValue({ args0 -> args0 }))
            .isEnabled(
                isEnabled.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionArgs].
 */
@PulumiTagMarker
public class ExtensionArgsBuilder internal constructor() {
    private var additionalExtensionProperties: Output<Any>? = null

    private var isEnabled: Output<Either<String, IsEnabled>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Property values associated with the extension.
     */
    @JvmName("kyvswqoiivillsji")
    public suspend fun additionalExtensionProperties(`value`: Output<Any>) {
        this.additionalExtensionProperties = value
    }

    /**
     * @param value Indicates whether the extension is enabled.
     */
    @JvmName("jnljrlwnncwwpbnm")
    public suspend fun isEnabled(`value`: Output<Either<String, IsEnabled>>) {
        this.isEnabled = value
    }

    /**
     * @param value The extension name. Supported values are: <br><br>**AgentlessDiscoveryForKubernetes** - API-based discovery of information about Kubernetes cluster architecture, workload objects, and setup. Required for Kubernetes inventory, identity and network exposure detection, attack path analysis and risk hunting as part of the cloud security explorer.
     * Available for CloudPosture plan.<br><br>**OnUploadMalwareScanning** - Limits the GB to be scanned per month for each storage account within the subscription. Once this limit reached on a given storage account, Blobs won't be scanned during current calendar month.
     * Available for StorageAccounts plan.<br><br>**SensitiveDataDiscovery** - Sensitive data discovery identifies Blob storage container with sensitive data such as credentials, credit cards, and more, to help prioritize and investigate security events.
     * Available for StorageAccounts and CloudPosture plans.<br><br>**ContainerRegistriesVulnerabilityAssessments** - Provides vulnerability management for images stored in your container registries.
     * Available for CloudPosture and Containers plans.
     */
    @JvmName("kpwqjaxlkkikxltl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Property values associated with the extension.
     */
    @JvmName("pyqihjglsdktoiyw")
    public suspend fun additionalExtensionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalExtensionProperties = mapped
    }

    /**
     * @param value Indicates whether the extension is enabled.
     */
    @JvmName("utimhshnuwlbcxbr")
    public suspend fun isEnabled(`value`: Either<String, IsEnabled>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Indicates whether the extension is enabled.
     */
    @JvmName("ghiqjrhddeonocuf")
    public fun isEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IsEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Indicates whether the extension is enabled.
     */
    @JvmName("tlkrawjrflakdvhk")
    public fun isEnabled(`value`: IsEnabled) {
        val toBeMapped = Either.ofRight<String, IsEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The extension name. Supported values are: <br><br>**AgentlessDiscoveryForKubernetes** - API-based discovery of information about Kubernetes cluster architecture, workload objects, and setup. Required for Kubernetes inventory, identity and network exposure detection, attack path analysis and risk hunting as part of the cloud security explorer.
     * Available for CloudPosture plan.<br><br>**OnUploadMalwareScanning** - Limits the GB to be scanned per month for each storage account within the subscription. Once this limit reached on a given storage account, Blobs won't be scanned during current calendar month.
     * Available for StorageAccounts plan.<br><br>**SensitiveDataDiscovery** - Sensitive data discovery identifies Blob storage container with sensitive data such as credentials, credit cards, and more, to help prioritize and investigate security events.
     * Available for StorageAccounts and CloudPosture plans.<br><br>**ContainerRegistriesVulnerabilityAssessments** - Provides vulnerability management for images stored in your container registries.
     * Available for CloudPosture and Containers plans.
     */
    @JvmName("pmciavdxtacwtbaq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ExtensionArgs = ExtensionArgs(
        additionalExtensionProperties = additionalExtensionProperties,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
