@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GcpProjectEnvironmentDataArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The GCP project connector environment data
 * @property environmentType The type of the environment data.
 * Expected value is 'GcpProject'.
 * @property organizationalData The Gcp project's organizational data
 * @property projectDetails The Gcp project's details
 */
public data class GcpProjectEnvironmentDataArgs(
    public val environmentType: Output<String>,
    public val organizationalData: Output<Either<GcpOrganizationalDataMemberArgs, GcpOrganizationalDataOrganizationArgs>>? =
        null,
    public val projectDetails: Output<GcpProjectDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GcpProjectEnvironmentDataArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GcpProjectEnvironmentDataArgs =
        com.pulumi.azurenative.security.inputs.GcpProjectEnvironmentDataArgs.builder()
            .environmentType(environmentType.applyValue({ args0 -> args0 }))
            .organizationalData(
                organizationalData?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .projectDetails(
                projectDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GcpProjectEnvironmentDataArgs].
 */
@PulumiTagMarker
public class GcpProjectEnvironmentDataArgsBuilder internal constructor() {
    private var environmentType: Output<String>? = null

    private var organizationalData:
        Output<Either<GcpOrganizationalDataMemberArgs, GcpOrganizationalDataOrganizationArgs>>? = null

    private var projectDetails: Output<GcpProjectDetailsArgs>? = null

    /**
     * @param value The type of the environment data.
     * Expected value is 'GcpProject'.
     */
    @JvmName("xlndhoicmefdppji")
    public suspend fun environmentType(`value`: Output<String>) {
        this.environmentType = value
    }

    /**
     * @param value The Gcp project's organizational data
     */
    @JvmName("sflnxipbrmfcbmeh")
    public suspend fun organizationalData(`value`: Output<Either<GcpOrganizationalDataMemberArgs, GcpOrganizationalDataOrganizationArgs>>) {
        this.organizationalData = value
    }

    /**
     * @param value The Gcp project's details
     */
    @JvmName("rwgkmhrtyhgmlvpc")
    public suspend fun projectDetails(`value`: Output<GcpProjectDetailsArgs>) {
        this.projectDetails = value
    }

    /**
     * @param value The type of the environment data.
     * Expected value is 'GcpProject'.
     */
    @JvmName("obiflakdvyycblmj")
    public suspend fun environmentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value The Gcp project's organizational data
     */
    @JvmName("ndxrcraiuakhkeft")
    public suspend fun organizationalData(`value`: Either<GcpOrganizationalDataMemberArgs, GcpOrganizationalDataOrganizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalData = mapped
    }

    /**
     * @param value The Gcp project's organizational data
     */
    @JvmName("vlvqpwkxdurykcul")
    public fun organizationalData(`value`: GcpOrganizationalDataMemberArgs) {
        val toBeMapped = Either.ofLeft<
            GcpOrganizationalDataMemberArgs,
            GcpOrganizationalDataOrganizationArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalData = mapped
    }

    /**
     * @param value The Gcp project's organizational data
     */
    @JvmName("lssmldwnurvkxcvm")
    public fun organizationalData(`value`: GcpOrganizationalDataOrganizationArgs) {
        val toBeMapped = Either.ofRight<
            GcpOrganizationalDataMemberArgs,
            GcpOrganizationalDataOrganizationArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalData = mapped
    }

    /**
     * @param value The Gcp project's details
     */
    @JvmName("wjvpnomgrbwyvdmg")
    public suspend fun projectDetails(`value`: GcpProjectDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectDetails = mapped
    }

    /**
     * @param argument The Gcp project's details
     */
    @JvmName("alyclptjhhahpjfa")
    public suspend fun projectDetails(argument: suspend GcpProjectDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = GcpProjectDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.projectDetails = mapped
    }

    internal fun build(): GcpProjectEnvironmentDataArgs = GcpProjectEnvironmentDataArgs(
        environmentType = environmentType ?: throw PulumiNullFieldException("environmentType"),
        organizationalData = organizationalData,
        projectDetails = projectDetails,
    )
}
