@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAPICollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiCollectionId A string representing the apiCollections resource within the Microsoft.Security provider namespace. This string matches the Azure API Management API name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetAPICollectionPlainArgs(
    public val apiCollectionId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAPICollectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetAPICollectionPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAPICollectionPlainArgs.builder()
            .apiCollectionId(apiCollectionId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAPICollectionPlainArgs].
 */
@PulumiTagMarker
public class GetAPICollectionPlainArgsBuilder internal constructor() {
    private var apiCollectionId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value A string representing the apiCollections resource within the Microsoft.Security provider namespace. This string matches the Azure API Management API name.
     */
    @JvmName("dpecedggbmglymlf")
    public suspend fun apiCollectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiCollectionId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("llbayitixkaurhdt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("worekhtxmwkgcutv")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetAPICollectionPlainArgs = GetAPICollectionPlainArgs(
        apiCollectionId = apiCollectionId ?: throw PulumiNullFieldException("apiCollectionId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
