@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAssessmentsMetadataSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assessmentMetadataName The Assessment Key - Unique key for the assessment type
 */
public data class GetAssessmentsMetadataSubscriptionPlainArgs(
    public val assessmentMetadataName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAssessmentsMetadataSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetAssessmentsMetadataSubscriptionPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAssessmentsMetadataSubscriptionPlainArgs.builder()
            .assessmentMetadataName(assessmentMetadataName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssessmentsMetadataSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetAssessmentsMetadataSubscriptionPlainArgsBuilder internal constructor() {
    private var assessmentMetadataName: String? = null

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("bunshrpvipbxwbyh")
    public suspend fun assessmentMetadataName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assessmentMetadataName = mapped
    }

    internal fun build(): GetAssessmentsMetadataSubscriptionPlainArgs =
        GetAssessmentsMetadataSubscriptionPlainArgs(
            assessmentMetadataName = assessmentMetadataName ?: throw
                PulumiNullFieldException("assessmentMetadataName"),
        )
}
