@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAutomationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationName The security automation name.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetAutomationPlainArgs(
    public val automationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAutomationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetAutomationPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAutomationPlainArgs.builder()
            .automationName(automationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAutomationPlainArgs].
 */
@PulumiTagMarker
public class GetAutomationPlainArgsBuilder internal constructor() {
    private var automationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The security automation name.
     */
    @JvmName("eyctdqbsscvvoamp")
    public suspend fun automationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("bhtlwamsgcilrlal")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAutomationPlainArgs = GetAutomationPlainArgs(
        automationName = automationName ?: throw PulumiNullFieldException("automationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
