@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAzureServersSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property settingKind The kind of the server vulnerability assessments setting
 */
public data class GetAzureServersSettingPlainArgs(
    public val settingKind: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAzureServersSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetAzureServersSettingPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAzureServersSettingPlainArgs.builder()
            .settingKind(settingKind.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzureServersSettingPlainArgs].
 */
@PulumiTagMarker
public class GetAzureServersSettingPlainArgsBuilder internal constructor() {
    private var settingKind: String? = null

    /**
     * @param value The kind of the server vulnerability assessments setting
     */
    @JvmName("yhoexmkfwpqmywxx")
    public suspend fun settingKind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.settingKind = mapped
    }

    internal fun build(): GetAzureServersSettingPlainArgs = GetAzureServersSettingPlainArgs(
        settingKind = settingKind ?: throw PulumiNullFieldException("settingKind"),
    )
}
