@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetDefenderForStoragePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceId The identifier of the resource.
 * @property settingName Defender for Storage setting name.
 */
public data class GetDefenderForStoragePlainArgs(
    public val resourceId: String,
    public val settingName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetDefenderForStoragePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetDefenderForStoragePlainArgs =
        com.pulumi.azurenative.security.inputs.GetDefenderForStoragePlainArgs.builder()
            .resourceId(resourceId.let({ args0 -> args0 }))
            .settingName(settingName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDefenderForStoragePlainArgs].
 */
@PulumiTagMarker
public class GetDefenderForStoragePlainArgsBuilder internal constructor() {
    private var resourceId: String? = null

    private var settingName: String? = null

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("edqaunqxlhxdhngb")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value Defender for Storage setting name.
     */
    @JvmName("nrkqrhuwxcvwcsna")
    public suspend fun settingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.settingName = mapped
    }

    internal fun build(): GetDefenderForStoragePlainArgs = GetDefenderForStoragePlainArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        settingName = settingName ?: throw PulumiNullFieldException("settingName"),
    )
}
