@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetDevOpsPolicyAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyAssignmentId The policy assignment Id.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 */
public data class GetDevOpsPolicyAssignmentPlainArgs(
    public val policyAssignmentId: String,
    public val resourceGroupName: String,
    public val securityConnectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetDevOpsPolicyAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetDevOpsPolicyAssignmentPlainArgs =
        com.pulumi.azurenative.security.inputs.GetDevOpsPolicyAssignmentPlainArgs.builder()
            .policyAssignmentId(policyAssignmentId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDevOpsPolicyAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetDevOpsPolicyAssignmentPlainArgsBuilder internal constructor() {
    private var policyAssignmentId: String? = null

    private var resourceGroupName: String? = null

    private var securityConnectorName: String? = null

    /**
     * @param value The policy assignment Id.
     */
    @JvmName("jmnkxfpnrpokqgtg")
    public suspend fun policyAssignmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyAssignmentId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lyowakaeaypqnfrd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("dcseiuormqikwiky")
    public suspend fun securityConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityConnectorName = mapped
    }

    internal fun build(): GetDevOpsPolicyAssignmentPlainArgs = GetDevOpsPolicyAssignmentPlainArgs(
        policyAssignmentId = policyAssignmentId ?: throw PulumiNullFieldException("policyAssignmentId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securityConnectorName = securityConnectorName ?: throw
            PulumiNullFieldException("securityConnectorName"),
    )
}
